
#  $rackup config.ru
#  Access http://localhost:9292

require 'rubygems'
require 'sinatra'
require 'haml'
require 'sass'
require 'yaml'
require 'json'
require 'pp'

set :public, File.dirname(__FILE__) + '/public'

helpers do
  include Rack::Utils; alias_method :h, :escape_html
end

# データ読込み
SICS = YAML.load_file('sic.yml')
CIKS = YAML.load_file('cik.yml')
EDINET = YAML.load_file('edinet.yml')

get '/style.css' do
  content_type 'text/css', :charset => 'utf-8'
  sass :style
end

get '/' do
  redirect 'index.html'
end

get '/sic' do
  @search = nil
  @result = []
  haml :index
end

get '/search-sic' do
  redirect '/sic'
end

put '/search-sic' do
  @search = 'sic'
  @sic = request[:sic]
  @sic = '' if @sic == nil

  @industry = request[:industry]
  @industry = '' if @industry == nil

  rsic = Regexp.new(@sic, Regexp::IGNORECASE)
  rindustry = Regexp.new(@industry, Regexp::IGNORECASE)

  @result = []
  if @sic != '' or @industry != ''
    SICS.each do |info|
      data = { :sic => info[0] }.merge!(info[1])
      if rsic =~ data[:sic].to_s and rindustry =~ data[:industry].to_s
        @result << data
      end
    end
    @result.sort!{|x, y| x[:sic]  <=> y[:sic] }
  end
  haml :index
end

get '/search-cik' do
  redirect '/sic'
end

put '/search-cik' do
  @search = 'cik'

  @cik = request[:cik]
  @cik = '' if @cik == nil

  @company = request[:company]
  @company = '' if @company == nil

  @sic2 = request[:sic]
  @sic2 = '' if @sic2 == nil

  rcik = Regexp.new(@cik, Regexp::IGNORECASE)
  rcompany = Regexp.new(@company, Regexp::IGNORECASE)
  rsic2 = Regexp.new(@sic2, Regexp::IGNORECASE)

  @result = []
  if @cik != '' or @company != '' or @sic2 != ''
    CIKS.each do |info|
      data = { :company => info[0] }.merge!(info[1])
      if rcik =~ data[:cik].to_s and rcompany =~ data[:company].to_s and rsic2 =~ data[:sic].to_s
        @result << data
      end
    end
    @result.sort!{|x, y| x[:cik]  <=> y[:cik] }
  end
  haml :index
end

get '/search-edinetcode' do
  redirect '/sic'
end

put '/search-edinetcode' do
  @search = 'edinetcode'

  @edinetcode = request[:edinetcode]
  @edinetcode = '' if @edinetcode == nil

  @edinetcompany = request[:edinetcompany]
  @edinetcompany = '' if @edinetcompany == nil

  @edinetaddress = request[:edinetaddress]
  @edinetaddress = '' if @edinetaddress == nil

  rcode = Regexp.new(@edinetcode, Regexp::IGNORECASE)
  rcompany = Regexp.new(@edinetcompany, Regexp::IGNORECASE)
  raddress = Regexp.new(@edinetaddress, Regexp::IGNORECASE)

  @result = []
  if @edinetcode != '' or @edinetcompany != '' or @edinetaddress != ''
    EDINET.each do |info|
      data = { :company => info[0] }.merge!(info[1])
      if rcode =~ data[:code].to_s and rcompany =~ data[:company].to_s and raddress =~ data[:address].to_s
        @result << data
      end
    end
    @result.sort!{|x, y| x[:code]  <=> y[:code] }
  end
  haml :index
end

get '/zip' do
  haml :zip, :layout => false
end

get '/sic_grid' do
  haml :sic_grid, :layout => false
end

get '/app/sic.json' do
  # start=0&limit=20
  pp request
  
  content_type :json

  File.open( 'sic.json' ) do |io|
    data = JSON.parse(io.read)
    data.to_json
  end
end