/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Security;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import junit.framework.TestCase;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValidateSignatureTest
extends TestCase {
    private SignatureValidator validator;
    private File dir;

    public ValidateSignatureTest(String string) {
        super(string);
        String string2 = System.getProperty("file.separator");
        String string3 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.dir = new File(string3 + string2 + "data" + string2 + "javax" + string2 + "xml" + string2 + "crypto", "dsig");
        this.validator = new SignatureValidator(this.dir);
    }

    public void test_signature_with_ID() throws Exception {
        String string = "envelopingSignature.xml";
        DOMValidateContext dOMValidateContext = this.validator.getValidateContext(string, new KeySelectors.KeyValueKeySelector());
        Document document = dOMValidateContext.getNode().getOwnerDocument();
        NodeList nodeList = document.getElementsByTagName("Assertion");
        dOMValidateContext.setIdAttributeNS((Element)nodeList.item(0), null, "AssertionID");
        boolean bl = this.validator.validate(dOMValidateContext);
        ValidateSignatureTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_signature_external_c14n_xmlattrs() throws Exception {
        String string = "signature-external-c14n-xmlatrs.xml";
        boolean bl = this.validator.validate(string, new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
        ValidateSignatureTest.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    public void test_invalid_signature() throws Exception {
        InvalidURIDereferencer invalidURIDereferencer = new InvalidURIDereferencer();
        boolean bl = this.validator.validate("invalid-signature.xml", new KeySelectors.KeyValueKeySelector(), invalidURIDereferencer);
        ValidateSignatureTest.assertFalse((String)"Invalid signature should fail!", (boolean)bl);
        ValidateSignatureTest.assertTrue((String)"References validated before signature", (boolean)invalidURIDereferencer.dereferenced);
    }

    public void test_signature_enveloping_hmac_sha1_trunclen_0() throws Exception {
        try {
            boolean bl = this.validator.validate("signature-enveloping-hmac-sha1-trunclen-0-attack.xml", new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
            ValidateSignatureTest.fail((String)"Expected HMACOutputLength exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            System.out.println(xMLSignatureException.getMessage());
        }
    }

    public void test_signature_enveloping_hmac_sha1_trunclen_8() throws Exception {
        try {
            boolean bl = this.validator.validate("signature-enveloping-hmac-sha1-trunclen-8-attack.xml", new KeySelectors.SecretKeySelector("secret".getBytes("ASCII")));
            ValidateSignatureTest.fail((String)"Expected HMACOutputLength exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            System.out.println(xMLSignatureException.getMessage());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ValidateSignatureTest validateSignatureTest = new ValidateSignatureTest("");
        validateSignatureTest.test_signature_with_ID();
        validateSignatureTest.test_signature_external_c14n_xmlattrs();
    }

    static {
        Security.insertProviderAt(new XMLDSigRI(), 1);
    }

    static class InvalidURIDereferencer
    implements URIDereferencer {
        boolean dereferenced = false;
        private URIDereferencer ud = XMLSignatureFactory.getInstance().getURIDereferencer();

        InvalidURIDereferencer() {
        }

        public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
            this.dereferenced = true;
            return this.ud.dereference(uRIReference, xMLCryptoContext);
        }
    }
}

