// See http://d.hatena.ne.jp/fits/20090815/1250352312

package calc.dsl

import scala.actors.Actor._
import scala.actors.remote.Node
import scala.actors.remote.RemoteActor.select

object client {
    def main(args: Array[String]) {
        val name = Symbol("calc") // シンボルの設定
        val host = "localhost"
        val defaultPort = 9000
        val port = if (args.length > 0) Integer.parseInt(args(0)) else defaultPort  //ポート番号の設定

        val node = Node(host, port)
        val timeout = 1000 // 1 秒

        Console.println("Start client.")

        showPrompt
        var expr = readExpression
        while(expr.length > 0) {
            actor {
                val consumer = select(node, name)
                // RemoteActor に送信
                consumer !?(timeout, expr) match {
                    // RemoteActor からの返信を表示
                    case Some((eval,evalx)) => {
                            Console.println("  expr:    " + expr)
                            Console.println("  result:  " + eval)
                            Console.println("  resultx: " + evalx)
                        }
                    case y => {
                            Console.println("  result:" + y + " (=" + expr + ")")
                        }
                }
                showPrompt
            }
            expr = readExpression
        }
        Console.println("Stop client.")
    }

    def showPrompt = { Console.println("Input Expression:") }
    def readExpression = { Console.readLine }
}