/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

class CleanupQueue {
    public static final Log LOG = LogFactory.getLog(CleanupQueue.class);
    private static PathCleanupThread cleanupThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CleanupQueue() {
        Class<PathCleanupThread> clazz = PathCleanupThread.class;
        synchronized (PathCleanupThread.class) {
            if (cleanupThread == null) {
                cleanupThread = new PathCleanupThread();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void addToQueue(JobConf conf, Path ... paths) {
        cleanupThread.addToQueue(conf, paths);
    }

    private static class PathCleanupThread
    extends Thread {
        private LinkedBlockingQueue<PathAndConf> queue = new LinkedBlockingQueue();

        public PathCleanupThread() {
            this.setName("Directory/File cleanup thread");
            this.setDaemon(true);
            this.start();
        }

        public void addToQueue(JobConf conf, Path ... paths) {
            for (Path p : paths) {
                try {
                    this.queue.put(new PathAndConf(conf, p));
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            LOG.debug((Object)(this.getName() + " started."));
            PathAndConf pathAndConf = null;
            while (true) {
                try {
                    while (true) {
                        pathAndConf = this.queue.take();
                        FileSystem fs = pathAndConf.path.getFileSystem(pathAndConf.conf);
                        fs.delete(pathAndConf.path, true);
                        LOG.debug((Object)("DELETED " + pathAndConf.path));
                    }
                }
                catch (InterruptedException t) {
                    return;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Error deleting path" + pathAndConf.path));
                    continue;
                }
                break;
            }
        }

        static class PathAndConf {
            JobConf conf;
            Path path;

            PathAndConf(JobConf conf, Path path) {
                this.conf = conf;
                this.path = path;
            }
        }
    }
}

