// See http://d.hatena.ne.jp/fits/20090815/1250352312

package calc.dsl

import scala.actors.Actor._
import scala.actors.remote.RemoteActor.alive
import scala.actors.remote.RemoteActor.register

object server extends {

    def main(args: Array[String]) {
        val name = Symbol("calc") // シンボルの設定
        val defaultPort = 9000
        val port = if (args.length > 0) Integer.parseInt(args(0)) else defaultPort //ポート番号の設定

        actor {
            alive(port)
            register(name, self)
            loop {
                receive {
                    case msg => {
                            Console.println("received=" + msg)
                            try {
                                // reply( ("evaluate=" + Calc.evaluate(msg.toString), Calc.parse(msg.toString)))
                                reply( (Calc3.evaluate(msg.toString).toString,
                                        Calc3.evaluate(msg.toString).toPeriodString))
                            } catch {
                                case e => reply("Error=" + e.toString)
                            }
                        }
                }
            }
        }
    }
}