/*
 * Copyright (C) 2008N {La
 * 
 * ̃vO̓t[\tgEFAłBȂ͂At[\tgEF
 * AcɂĔsꂽGNU 򓙈ʌOp_(o[W3 
 * A]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉
 * ĔЕz܂͉ς邱Ƃł܂B
 * 
 * ̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
 * łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
 * ߑS݂܂BڂGNU 򓙈ʌOp_񏑂
 * B
 * 
 * Ȃ͂̃vOƋɁAGNU 򓙈ʌOp_񏑂̕
 * ꕔ󂯎͂łB󂯎ĂȂ΁A
 * <http://www.gnu.org/licenses/> B
 */
package minicmds.diff;

import java.io.PrintStream;
import java.util.List;

import org.incava.util.diff.Difference;

public class DiffWriter {
	private static final String TYPE_DEL = "d";
	private static final String TYPE_ADD = "a";
	private static final String TYPE_CHANGE = "c";

	private static final String PREFIX_DEL = "< ";
	private static final String PREFIX_ADD = "> ";
	private static final String SEP = "---";

	/**
	 * Xg̏o
	 * 
	 * @param ps
	 *            o͐
	 * @param before
	 *            ύXO
	 * @param after
	 *            ύX㕶
	 * @param diffList
	 *            Xg
	 */
	public void printDiffList(PrintStream ps, Document before, Document after,
			List<Difference> diffList) {

		for (Difference diff : diffList) {
			int delStart = diff.getDeletedStart();
			int delEnd = diff.getDeletedEnd();
			int addStart = diff.getAddedStart();
			int addEnd = diff.getAddedEnd();
			String type;

			// 폜/ǉ/ύX\̔
			if (delEnd != Difference.NONE) {
				if (addEnd != Difference.NONE) {
					type = TYPE_CHANGE;
				} else {
					type = TYPE_DEL;
				}
			} else {
				type = TYPE_ADD;
			}

			// ʒugݗĂ
			ps.print(getRange(before, delStart, delEnd));
			ps.print(type);
			ps.print(getRange(after, addStart, addEnd));
			ps.println();

			// gݗĂ
			if (delEnd != Difference.NONE) {
				printText(ps, before, PREFIX_DEL, delStart, delEnd);
			}
			if (delEnd != Difference.NONE && addEnd != Difference.NONE) {
				ps.println(SEP);
			}
			if (addEnd != Difference.NONE) {
				printText(ps, after, PREFIX_ADD, addStart, addEnd);
			}
		}
	}

	private String getRange(Document doc, int start, int end) {
		StringBuffer sb = new StringBuffer();
		if (end == Difference.NONE) {
			sb.append(getPosition(doc, start - 1));
		} else {
			sb.append(getPosition(doc, start));
			if (start != end) {
				sb.append("," + getPosition(doc, end));
			}
		}
		return sb.toString();
	}

	private String getPosition(Document doc, int index) {
		StringBuffer sb = new StringBuffer();
		if (doc.getType() == Document.Type.EXCEL) {
			if (index < 0) {
				sb.append(doc.getSheetName(0));
				sb.append("-0-0");
			} else {
				sb.append(doc.getSheetName(index));
				sb.append("-");
				sb.append(doc.getRow(index) + 1);
				sb.append("-");
				sb.append(doc.getColumn(index) + 1);
			}
		} else {
			sb.append(index + 1);
		}
		return sb.toString();
	}

	private void printText(PrintStream ps, Document doc, String prefix, int start, int end) {
		for (int i = start; i <= end; i++) {
			ps.println(prefix + doc.get(i));
		}
	}
}
