/*
 * Copyright (C) 2006-2008N {La
 * 
 * ̃vO̓t[\tgEFAłBȂ͂At[\tgEF
 * AcɂĔsꂽGNU 򓙈ʌOp_(o[W3 
 * A]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉
 * ĔЕz܂͉ς邱Ƃł܂B
 * 
 * ̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
 * łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
 * ߑS݂܂BڂGNU 򓙈ʌOp_񏑂
 * B
 * 
 * Ȃ͂̃vOƋɁAGNU 򓙈ʌOp_񏑂̕
 * ꕔ󂯎͂łB󂯎ĂȂ΁A
 * <http://www.gnu.org/licenses/> B
 */
package minicmds.excelgrep;

import java.io.FileNotFoundException;
import java.io.IOException;

import minicmds.common.AppException;
import minicmds.common.ExcelDoc;
import minicmds.config.Define;
import minicmds.model.CellPointer;
import minicmds.model.ExcelGrepArgument;
import minicmds.model.SearchCondition;


public class ExcelGrepController {

	/**
	 * vO
	 */
	private static final String PROGRAM_NAME = "ExcelGrep";

	/**
	 * 
	 */
	private ExcelGrepArgument argument = new ExcelGrepArgument();

	/**
	 * |[g
	 */
	private ExcelGrepReport report;

	/**
	 * s
	 * 
	 * @param args
	 * @throws FileNotFoundException
	 * @throws IOException
	 * @throws AppException
	 */
	public void run(String[] args) throws FileNotFoundException, IOException, AppException {

		// ̉
		try {
			argument.set(args);

		} catch (AppException e) {
			System.out.println(e.getMessage());
			argument.printUsage(this.getClass().getSimpleName());

			// I
			return;
		}

		if (argument.isVersionFlag()) {

			// o[Wԍ\
			System.out.println("Version " + Define.VERSION);

		} else if (argument.isHelpFlag()) {

			// gp@\
			argument.printUsage(PROGRAM_NAME);

		} else {
			// t@C[v
			report = new ExcelGrepReport(argument);
			String[] path = argument.getPathArray();
			for (int i = 0; i < path.length; i++) {

				// t@Cǂݍ
				ExcelDoc doc = new ExcelDoc(path[i]);
				doc.read();

				// 
				SearchCondition searchCondition = new SearchCondition(argument.getPattern(), doc);

				// Greps
				searchCondition.run();
				CellPointer[] cellArray = searchCondition.getCellList();

				// ʕ\
				report.print(cellArray);
			}
		}
	}
}
