/*
 * Copyright (C) 2008N {La
 *
 * ̃vO̓t[\tgEFAłBȂ͂At[\tgEF
 * AcɂĔsꂽGNU 򓙈ʌOp_(o[W3
 * A]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉
 * ĔЕz܂͉ς邱Ƃł܂B
 *
 * ̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ*
 * łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
 * ߑS݂܂BڂGNU 򓙈ʌOp_񏑂
 * B
 *
 * Ȃ͂̃vOƋɁAGNU 򓙈ʌOp_񏑂̕
 * ꕔ󂯎͂łB󂯎ĂȂ΁A
 * <http://www.gnu.org/licenses/> B
 */
package minicmds.excelinfo;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

import minicmds.common.ExcelDoc;

public class ExcelInfo {

	private class MyFilenameFilter implements FilenameFilter {
		private static final String EXCLUDE_PATTERN = ".svn";

		public boolean accept(File dir, String name) {
			if (name.equals(EXCLUDE_PATTERN)) {
				return false;
			}
			return true;
		}
	}

	private Argument arg = new Argument();

	private AbstractWriter writer = null;

	private MyFilenameFilter filter = new MyFilenameFilter();

	/**
	 * JavaAvP[VC
	 *
	 * @param args
	 *            s
	 */
	public static void main(String[] args) {
		ExcelInfo main = new ExcelInfo();
		main.setArgument(args);
		main.setWriter(new PrintWriter());
		main.run();
	}

	/**
	 * @param args
	 */
	public void run() {
		// gp@o
		if (arg.isHelpFlag()) {
			arg.printUsage();
			return;
		}

		// fBNg/t@CċAIɏ
		procDirLoop(arg.getPath());
	}

	/**
	 * sݒ肷B
	 *
	 * @param args
	 */
	public void setArgument(String[] args) {
		arg.parse(args);
	}

	/**
	 * o͕@ݒ
	 *
	 * @param writer
	 */
	public void setWriter(AbstractWriter writer) {
		this.writer = writer;
	}

	/**
	 * @return
	 */
	public ExcelInfoDto[] getResult() {
		return writer.getDtoArray();
	}

	private void procDirLoop(String path) {

		File file = new File(path);
		if (file.isDirectory()) {
			String[] list = file.list(filter);

			// TODO \[g

			for (String subPath : list) {
				procDirLoop(path + "/" + subPath);
			}
		} else if (path.endsWith(".xls")) {
			// Excelt@C
			procFile(path);
		}
	}

	/**
	 * 1t@C
	 *
	 * @param filePath
	 */
	private void procFile(String filePath) {
		// t@Cǂݍ
		ExcelDoc doc = new ExcelDoc();
		try {
			doc.read(filePath);
		} catch (IOException e) {
			System.out.println("t@Cǂݍ݂Ɏs܂Bt@C=[" + filePath + "]");
			System.out.println(e.toString());
			return;
		}

		// o
		write(filePath, doc);
	}

	private void write(String filePath, ExcelDoc doc) {
		if (filePath == arg.getPath()) {
			filePath = "";
		} else {
			filePath = filePath.substring(arg.getPath().length() + 1);
		}
		writer.write(filePath, doc);
	}

}
