/*
 * Copyright (C) 2009N {La
 *
 * ̃vO̓t[\tgEFAłBȂ͂At[\tgEF
 * AcɂĔsꂽGNU 򓙈ʌOp_(o[W3
 * A]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉
 * ĔЕz܂͉ς邱Ƃł܂B
 *
 * ̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ*
 * łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
 * ߑS݂܂BڂGNU 򓙈ʌOp_񏑂
 * B
 *
 * Ȃ͂̃vOƋɁAGNU 򓙈ʌOp_񏑂̕
 * ꕔ󂯎͂łB󂯎ĂȂ΁A
 * <http://www.gnu.org/licenses/> B
 */
package minicmds.filelist;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;

public class FileList {

	private class MyFilenameFilter implements FilenameFilter {
		private final String EXCLUDE_PATTERN = arg.getExcludePattern();

		public boolean accept(File dir, String name) {
			if (name.equals(EXCLUDE_PATTERN)) {
				return false;
			}
			return true;
		}
	}

	private Argument arg = new Argument();

	private AbstractWriter writer = null;

	private MyFilenameFilter filter = new MyFilenameFilter();

	/**
	 * JavaAvP[VC
	 *
	 * @param args
	 *            s
	 */
	public static void main(String[] args) {
		FileList main = new FileList();
		main.setArgument(args);
		main.setWriter(new PrintWriter());
		main.run();
	}

	/**
	 * @param args
	 */
	public void run() {
		// gp@o
		if (arg.isHelpFlag()) {
			arg.printUsage();
			return;
		}

		// fBNg/t@CċAIɏ
		procDirLoop(arg.getPath());
	}

	/**
	 * sݒ肷B
	 *
	 * @param args
	 */
	public void setArgument(String[] args) {
		arg.parse(args);
	}

	/**
	 * o͕@ݒ
	 *
	 * @param writer
	 */
	public void setWriter(AbstractWriter writer) {
		this.writer = writer;
	}

	/**
	 * o͌ʎ擾
	 *
	 * @return
	 */
	public List<File> getResult() {
		return writer.getDtoList();
	}

	private void procDirLoop(String path) {
		File file = new File(path);
		if (file.isDirectory()) {
			// fBNg
			String[] list = file.list(filter);
			Arrays.sort(list);
			for (String subPath : list) {
				procDirLoop(path + File.pathSeparator + subPath);
			}
		} else {
			// 1t@C
			writer.write(file);
		}
	}

}
