/*
 * Copyright (C) 2006-2008N {La
 * 
 * ̃vO̓t[\tgEFAłBȂ͂At[\tgEF
 * AcɂĔsꂽGNU 򓙈ʌOp_(o[W3 
 * A]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉
 * ĔЕz܂͉ς邱Ƃł܂B
 * 
 * ̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
 * łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
 * ߑS݂܂BڂGNU 򓙈ʌOp_񏑂
 * B
 * 
 * Ȃ͂̃vOƋɁAGNU 򓙈ʌOp_񏑂̕
 * ꕔ󂯎͂łB󂯎ĂȂ΁A
 * <http://www.gnu.org/licenses/> B
 */
package minicmds.model;

import java.util.ArrayList;
import java.util.Arrays;

import minicmds.common.AppException;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;


/**
 * NX
 * 
 * @author hiro
 */
public class ExcelGrepArgument {

	private static final String HELP_CHAR = "h";

	private static final String HELP_LONG = "help";

	private static final String LINE_NUMBER_CHAR = "n";

	private static final String RECURSIVE_CHAR = "r";

	private static final String VERSION_CHAR = "V";

	/**
	 * R}hC
	 */
	private CommandLine cmd = null;

	/**
	 * R}hCp[T[
	 */
	private CommandLineParser parser = new PosixParser();

	/**
	 * IvVW
	 */
	private Options options = new Options();

	/**
	 * 镶̃p^[
	 */
	private String pattern;

	/**
	 * Ώۂ̃t@CpXXg
	 */
	private String[] pathArray;

	/**
	 * RXgN^
	 */
	public ExcelGrepArgument() {

		Option helpFlag = new Option(HELP_CHAR, HELP_LONG, false, "gp@\܂B");

		Option lineNumberFlag = new Option(LINE_NUMBER_CHAR, "line-number",
				false, "eo͍s̑OɁA̓t@Cɂsԍ\܂B");

		Option recursiveFlag = new Option(RECURSIVE_CHAR, "recursive", false,
				"efBNĝׂẴt@CċAIɓǂݎ܂B");

		Option versionFlag = new Option(VERSION_CHAR, "version", false,
				"o[Wԍ\܂B");

		options.addOption(helpFlag);
		options.addOption(lineNumberFlag);
		options.addOption(recursiveFlag);
		options.addOption(versionFlag);
	}

	/**
	 * gp@̏o
	 */
	public void printUsage(String programName) {
		HelpFormatter help = new HelpFormatter();
		help.printHelp(programName + " [IvV] p^[ t@C ...", "IvV",
				options, "", false);

		System.out.println("K{");
		System.out.println(" p^[           Œ蕶BChJ[h␳K\͕sB");
		System.out.println(" t@C           t@C");
	}

	/**
	 * R}hC̈ݒ肷
	 * 
	 * @throws AppException
	 */
	public void set(String[] argArray) throws AppException {
		ArrayList pathList = new ArrayList();

		// ̉
		try {
			cmd = parser.parse(options, argArray);
		} catch (ParseException e) {
			throw new AppException("=" + Arrays.toString(argArray), e);
		}

		// IvVȊÖ̐[v
		for (int i = 0; i < cmd.getArgs().length; i++) {
			String arg = cmd.getArgs()[i];

			if (pattern == null) {
				pattern = arg;
			} else {
				pathList.add(arg);
			}
		}

		// pX̃ChJ[hWJ
		// javȁꍇAWindowsłIɃChJ[hWJĂ̂ŁAȂB
		pathArray = new String[pathList.size()];
		pathList.toArray(pathArray);

	}

	/**
	 * p^[̎擾
	 * 
	 */
	public String getPattern() {
		return pattern;
	}

	/**
	 * @return pathArray ߂܂B
	 */
	public String[] getPathArray() {
		return pathArray;
	}

	/**
	 * @return helpFlag ߂܂B
	 */
	public boolean isHelpFlag() {
		if (cmd.hasOption(HELP_CHAR)) {
			return true;
		} else if (cmd.getArgList().size() == 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * @return lineNumberFlag ߂܂B
	 */
	public boolean isLineNumberFlag() {
		return cmd.hasOption(LINE_NUMBER_CHAR);
	}

	/**
	 * @return versionFlag ߂܂B
	 */
	public boolean isVersionFlag() {
		return cmd.hasOption(VERSION_CHAR);
	}

}
