/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pair<L, R>
implements Serializable {
    private static final long serialVersionUID = 4954918890077093841L;
    public final L left;
    public final R right;

    public Pair(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return ObjectUtils.equals(this.left, other.left) && ObjectUtils.equals(this.right, other.right);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.left).append(this.right).toHashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.left);
        builder.append(",");
        builder.append(this.right);
        builder.append(")");
        return builder.toString();
    }

    public static <L, R> Pair<L, R> of(L left, R right) {
        return new Pair<L, R>(left, right);
    }
}

