#!/usr/local/bin/ruby
#vim: set fileencoding:utf-8

# mingwに含まれるddk/ntstatus.hから定数名と値を取り出して、rubyで簡単に利用できるようにするための変換鬼。
# ddk/ntstatus.hはPublic Domainにあるので、変換後のrubyスクリプトもそれに倣うことにします。

$stdout.binmode

puts <<__END__
module Win32
    module NTSTATUS
        LOOKUP = {}
        ERRNO = {}

        [
__END__

src = File.read("c:/mingw32/include/ddk/ntstatus.h", mode: "r:binary")
constants = src.scan(/^#define\s+(STATUS_\w+)\s+\(\(NTSTATUS\)(0x[0-9A-Fa-f]+)L?\)/)
constants.map! do |const, value|
    "            [:#{const}, #{" " * (64 - const.length)}#{value}, Errno::EPERM::Errno],\n"
end

puts constants

puts <<__END__
        ].each do |a, b, c|
            const_set(a, b)
            LOOKUP[b] ||= a
            ERRNO[b] ||= c
        end

        def self.raise(status, bt = caller)
            mesg = LOOKUP[status] || ("unknown status - %08x" % status)
            errno = ERRNO[status] || Errno::EPERM::Errno
            except = SystemCallError.new(mesg.to_s, errno)
            except.set_backtrace(bt)
            Kernel.raise(except)
        end
    end
end
__END__
