module Win32
    module NTSTATUS
        LOOKUP = {}
        ERRNO = {}

        [
            [:STATUS_SUCCESS,                                                   0x00000000, Errno::EPERM::Errno],
            [:STATUS_WAIT_0,                                                    0x00000000, Errno::EPERM::Errno],
            [:STATUS_WAIT_1,                                                    0x00000001, Errno::EPERM::Errno],
            [:STATUS_WAIT_2,                                                    0x00000002, Errno::EPERM::Errno],
            [:STATUS_WAIT_3,                                                    0x00000003, Errno::EPERM::Errno],
            [:STATUS_WAIT_63,                                                   0x0000003F, Errno::EPERM::Errno],
            [:STATUS_ABANDONED,                                                 0x00000080, Errno::EPERM::Errno],
            [:STATUS_ABANDONED_WAIT_0,                                          0x00000080, Errno::EPERM::Errno],
            [:STATUS_ABANDONED_WAIT_63,                                         0x000000BF, Errno::EPERM::Errno],
            [:STATUS_USER_APC,                                                  0x000000C0, Errno::EPERM::Errno],
            [:STATUS_KERNEL_APC,                                                0x00000100, Errno::EPERM::Errno],
            [:STATUS_ALERTED,                                                   0x00000101, Errno::EPERM::Errno],
            [:STATUS_TIMEOUT,                                                   0x00000102, Errno::EPERM::Errno],
            [:STATUS_PENDING,                                                   0x00000103, Errno::EPERM::Errno],
            [:STATUS_REPARSE,                                                   0x00000104, Errno::EPERM::Errno],
            [:STATUS_MORE_ENTRIES,                                              0x00000105, Errno::EPERM::Errno],
            [:STATUS_NOT_ALL_ASSIGNED,                                          0x00000106, Errno::EPERM::Errno],
            [:STATUS_SOME_NOT_MAPPED,                                           0x00000107, Errno::EPERM::Errno],
            [:STATUS_OPLOCK_BREAK_IN_PROGRESS,                                  0x00000108, Errno::EPERM::Errno],
            [:STATUS_VOLUME_MOUNTED,                                            0x00000109, Errno::EPERM::Errno],
            [:STATUS_RXACT_COMMITTED,                                           0x0000010A, Errno::EPERM::Errno],
            [:STATUS_NOTIFY_CLEANUP,                                            0x0000010B, Errno::EPERM::Errno],
            [:STATUS_NOTIFY_ENUM_DIR,                                           0x0000010C, Errno::EPERM::Errno],
            [:STATUS_NO_QUOTAS_FOR_ACCOUNT,                                     0x0000010D, Errno::EPERM::Errno],
            [:STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED,                          0x0000010E, Errno::EPERM::Errno],
            [:STATUS_PAGE_FAULT_TRANSITION,                                     0x00000110, Errno::EPERM::Errno],
            [:STATUS_PAGE_FAULT_DEMAND_ZERO,                                    0x00000111, Errno::EPERM::Errno],
            [:STATUS_PAGE_FAULT_COPY_ON_WRITE,                                  0x00000112, Errno::EPERM::Errno],
            [:STATUS_PAGE_FAULT_GUARD_PAGE,                                     0x00000113, Errno::EPERM::Errno],
            [:STATUS_PAGE_FAULT_PAGING_FILE,                                    0x00000114, Errno::EPERM::Errno],
            [:STATUS_CACHE_PAGE_LOCKED,                                         0x00000115, Errno::EPERM::Errno],
            [:STATUS_CRASH_DUMP,                                                0x00000116, Errno::EPERM::Errno],
            [:STATUS_BUFFER_ALL_ZEROS,                                          0x00000117, Errno::EPERM::Errno],
            [:STATUS_REPARSE_OBJECT,                                            0x00000118, Errno::EPERM::Errno],
            [:STATUS_RESOURCE_REQUIREMENTS_CHANGED,                             0x00000119, Errno::EPERM::Errno],
            [:STATUS_TRANSLATION_COMPLETE,                                      0x00000120, Errno::EPERM::Errno],
            [:STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY,                           0x00000121, Errno::EPERM::Errno],
            [:STATUS_NOTHING_TO_TERMINATE,                                      0x00000122, Errno::EPERM::Errno],
            [:STATUS_PROCESS_NOT_IN_JOB,                                        0x00000123, Errno::EPERM::Errno],
            [:STATUS_PROCESS_IN_JOB,                                            0x00000124, Errno::EPERM::Errno],
            [:STATUS_OBJECT_NAME_EXISTS,                                        0x40000000, Errno::EPERM::Errno],
            [:STATUS_THREAD_WAS_SUSPENDED,                                      0x40000001, Errno::EPERM::Errno],
            [:STATUS_WORKING_SET_LIMIT_RANGE,                                   0x40000002, Errno::EPERM::Errno],
            [:STATUS_IMAGE_NOT_AT_BASE,                                         0x40000003, Errno::EPERM::Errno],
            [:STATUS_RXACT_STATE_CREATED,                                       0x40000004, Errno::EPERM::Errno],
            [:STATUS_SEGMENT_NOTIFICATION,                                      0x40000005, Errno::EPERM::Errno],
            [:STATUS_LOCAL_USER_SESSION_KEY,                                    0x40000006, Errno::EPERM::Errno],
            [:STATUS_BAD_CURRENT_DIRECTORY,                                     0x40000007, Errno::EPERM::Errno],
            [:STATUS_SERIAL_MORE_WRITES,                                        0x40000008, Errno::EPERM::Errno],
            [:STATUS_REGISTRY_RECOVERED,                                        0x40000009, Errno::EPERM::Errno],
            [:STATUS_FT_READ_RECOVERY_FROM_BACKUP,                              0x4000000A, Errno::EPERM::Errno],
            [:STATUS_FT_WRITE_RECOVERY,                                         0x4000000B, Errno::EPERM::Errno],
            [:STATUS_SERIAL_COUNTER_TIMEOUT,                                    0x4000000C, Errno::EPERM::Errno],
            [:STATUS_NULL_LM_PASSWORD,                                          0x4000000D, Errno::EPERM::Errno],
            [:STATUS_IMAGE_MACHINE_TYPE_MISMATCH,                               0x4000000E, Errno::EPERM::Errno],
            [:STATUS_RECEIVE_PARTIAL,                                           0x4000000F, Errno::EPERM::Errno],
            [:STATUS_RECEIVE_EXPEDITED,                                         0x40000010, Errno::EPERM::Errno],
            [:STATUS_RECEIVE_PARTIAL_EXPEDITED,                                 0x40000011, Errno::EPERM::Errno],
            [:STATUS_EVENT_DONE,                                                0x40000012, Errno::EPERM::Errno],
            [:STATUS_EVENT_PENDING,                                             0x40000013, Errno::EPERM::Errno],
            [:STATUS_CHECKING_FILE_SYSTEM,                                      0x40000014, Errno::EPERM::Errno],
            [:STATUS_FATAL_APP_EXIT,                                            0x40000015, Errno::EPERM::Errno],
            [:STATUS_PREDEFINED_HANDLE,                                         0x40000016, Errno::EPERM::Errno],
            [:STATUS_WAS_UNLOCKED,                                              0x40000017, Errno::EPERM::Errno],
            [:STATUS_SERVICE_NOTIFICATION,                                      0x40000018, Errno::EPERM::Errno],
            [:STATUS_WAS_LOCKED,                                                0x40000019, Errno::EPERM::Errno],
            [:STATUS_LOG_HARD_ERROR,                                            0x4000001A, Errno::EPERM::Errno],
            [:STATUS_ALREADY_WIN32,                                             0x4000001B, Errno::EPERM::Errno],
            [:STATUS_WX86_UNSIMULATE,                                           0x4000001C, Errno::EPERM::Errno],
            [:STATUS_WX86_CONTINUE,                                             0x4000001D, Errno::EPERM::Errno],
            [:STATUS_WX86_SINGLE_STEP,                                          0x4000001E, Errno::EPERM::Errno],
            [:STATUS_WX86_BREAKPOINT,                                           0x4000001F, Errno::EPERM::Errno],
            [:STATUS_WX86_EXCEPTION_CONTINUE,                                   0x40000020, Errno::EPERM::Errno],
            [:STATUS_WX86_EXCEPTION_LASTCHANCE,                                 0x40000021, Errno::EPERM::Errno],
            [:STATUS_WX86_EXCEPTION_CHAIN,                                      0x40000022, Errno::EPERM::Errno],
            [:STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE,                           0x40000023, Errno::EPERM::Errno],
            [:STATUS_NO_YIELD_PERFORMED,                                        0x40000024, Errno::EPERM::Errno],
            [:STATUS_TIMER_RESUME_IGNORED,                                      0x40000025, Errno::EPERM::Errno],
            [:STATUS_ARBITRATION_UNHANDLED,                                     0x40000026, Errno::EPERM::Errno],
            [:STATUS_CARDBUS_NOT_SUPPORTED,                                     0x40000027, Errno::EPERM::Errno],
            [:STATUS_WX86_CREATEWX86TIB,                                        0x40000028, Errno::EPERM::Errno],
            [:STATUS_MP_PROCESSOR_MISMATCH,                                     0x40000029, Errno::EPERM::Errno],
            [:STATUS_HIBERNATED,                                                0x4000002A, Errno::EPERM::Errno],
            [:STATUS_RESUME_HIBERNATION,                                        0x4000002B, Errno::EPERM::Errno],
            [:STATUS_GUARD_PAGE_VIOLATION,                                      0x80000001, Errno::EPERM::Errno],
            [:STATUS_DATATYPE_MISALIGNMENT,                                     0x80000002, Errno::EPERM::Errno],
            [:STATUS_BREAKPOINT,                                                0x80000003, Errno::EPERM::Errno],
            [:STATUS_SINGLE_STEP,                                               0x80000004, Errno::EPERM::Errno],
            [:STATUS_BUFFER_OVERFLOW,                                           0x80000005, Errno::EPERM::Errno],
            [:STATUS_NO_MORE_FILES,                                             0x80000006, Errno::EPERM::Errno],
            [:STATUS_WAKE_SYSTEM_DEBUGGER,                                      0x80000007, Errno::EPERM::Errno],
            [:STATUS_HANDLES_CLOSED,                                            0x8000000A, Errno::EPERM::Errno],
            [:STATUS_NO_INHERITANCE,                                            0x8000000B, Errno::EPERM::Errno],
            [:STATUS_GUID_SUBSTITUTION_MADE,                                    0x8000000C, Errno::EPERM::Errno],
            [:STATUS_PARTIAL_COPY,                                              0x8000000D, Errno::EPERM::Errno],
            [:STATUS_DEVICE_PAPER_EMPTY,                                        0x8000000E, Errno::EPERM::Errno],
            [:STATUS_DEVICE_POWERED_OFF,                                        0x8000000F, Errno::EPERM::Errno],
            [:STATUS_DEVICE_OFF_LINE,                                           0x80000010, Errno::EPERM::Errno],
            [:STATUS_DEVICE_BUSY,                                               0x80000011, Errno::EPERM::Errno],
            [:STATUS_NO_MORE_EAS,                                               0x80000012, Errno::EPERM::Errno],
            [:STATUS_INVALID_EA_NAME,                                           0x80000013, Errno::EPERM::Errno],
            [:STATUS_EA_LIST_INCONSISTENT,                                      0x80000014, Errno::EPERM::Errno],
            [:STATUS_INVALID_EA_FLAG,                                           0x80000015, Errno::EPERM::Errno],
            [:STATUS_VERIFY_REQUIRED,                                           0x80000016, Errno::EPERM::Errno],
            [:STATUS_EXTRANEOUS_INFORMATION,                                    0x80000017, Errno::EPERM::Errno],
            [:STATUS_RXACT_COMMIT_NECESSARY,                                    0x80000018, Errno::EPERM::Errno],
            [:STATUS_NO_MORE_ENTRIES,                                           0x8000001A, Errno::EPERM::Errno],
            [:STATUS_FILEMARK_DETECTED,                                         0x8000001B, Errno::EPERM::Errno],
            [:STATUS_MEDIA_CHANGED,                                             0x8000001C, Errno::EPERM::Errno],
            [:STATUS_BUS_RESET,                                                 0x8000001D, Errno::EPERM::Errno],
            [:STATUS_END_OF_MEDIA,                                              0x8000001E, Errno::EPERM::Errno],
            [:STATUS_BEGINNING_OF_MEDIA,                                        0x8000001F, Errno::EPERM::Errno],
            [:STATUS_MEDIA_CHECK,                                               0x80000020, Errno::EPERM::Errno],
            [:STATUS_SETMARK_DETECTED,                                          0x80000021, Errno::EPERM::Errno],
            [:STATUS_NO_DATA_DETECTED,                                          0x80000022, Errno::EPERM::Errno],
            [:STATUS_REDIRECTOR_HAS_OPEN_HANDLES,                               0x80000023, Errno::EPERM::Errno],
            [:STATUS_SERVER_HAS_OPEN_HANDLES,                                   0x80000024, Errno::EPERM::Errno],
            [:STATUS_ALREADY_DISCONNECTED,                                      0x80000025, Errno::EPERM::Errno],
            [:STATUS_LONGJUMP,                                                  0x80000026, Errno::EPERM::Errno],
            [:STATUS_CLEANER_CARTRIDGE_INSTALLED,                               0x80000027, Errno::EPERM::Errno],
            [:STATUS_PLUGPLAY_QUERY_VETOED,                                     0x80000028, Errno::EPERM::Errno],
            [:STATUS_UNWIND_CONSOLIDATE,                                        0x80000029, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_ALREADY_UP,                                   0x80130001, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_ALREADY_DOWN,                                 0x80130002, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NETWORK_ALREADY_ONLINE,                            0x80130003, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE,                           0x80130004, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_ALREADY_MEMBER,                               0x80130005, Errno::EPERM::Errno],
            [:STATUS_UNSUCCESSFUL,                                              0xC0000001, Errno::EPERM::Errno],
            [:STATUS_NOT_IMPLEMENTED,                                           0xC0000002, Errno::EPERM::Errno],
            [:STATUS_INVALID_INFO_CLASS,                                        0xC0000003, Errno::EPERM::Errno],
            [:STATUS_INFO_LENGTH_MISMATCH,                                      0xC0000004, Errno::EPERM::Errno],
            [:STATUS_ACCESS_VIOLATION,                                          0xC0000005, Errno::EPERM::Errno],
            [:STATUS_IN_PAGE_ERROR,                                             0xC0000006, Errno::EPERM::Errno],
            [:STATUS_PAGEFILE_QUOTA,                                            0xC0000007, Errno::EPERM::Errno],
            [:STATUS_INVALID_HANDLE,                                            0xC0000008, Errno::EPERM::Errno],
            [:STATUS_BAD_INITIAL_STACK,                                         0xC0000009, Errno::EPERM::Errno],
            [:STATUS_BAD_INITIAL_PC,                                            0xC000000A, Errno::EPERM::Errno],
            [:STATUS_INVALID_CID,                                               0xC000000B, Errno::EPERM::Errno],
            [:STATUS_TIMER_NOT_CANCELED,                                        0xC000000C, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER,                                         0xC000000D, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_DEVICE,                                            0xC000000E, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_FILE,                                              0xC000000F, Errno::EPERM::Errno],
            [:STATUS_INVALID_DEVICE_REQUEST,                                    0xC0000010, Errno::EPERM::Errno],
            [:STATUS_END_OF_FILE,                                               0xC0000011, Errno::EPERM::Errno],
            [:STATUS_WRONG_VOLUME,                                              0xC0000012, Errno::EPERM::Errno],
            [:STATUS_NO_MEDIA_IN_DEVICE,                                        0xC0000013, Errno::EPERM::Errno],
            [:STATUS_UNRECOGNIZED_MEDIA,                                        0xC0000014, Errno::EPERM::Errno],
            [:STATUS_NONEXISTENT_SECTOR,                                        0xC0000015, Errno::EPERM::Errno],
            [:STATUS_MORE_PROCESSING_REQUIRED,                                  0xC0000016, Errno::EPERM::Errno],
            [:STATUS_NO_MEMORY,                                                 0xC0000017, Errno::EPERM::Errno],
            [:STATUS_CONFLICTING_ADDRESSES,                                     0xC0000018, Errno::EPERM::Errno],
            [:STATUS_NOT_MAPPED_VIEW,                                           0xC0000019, Errno::EPERM::Errno],
            [:STATUS_UNABLE_TO_FREE_VM,                                         0xC000001A, Errno::EPERM::Errno],
            [:STATUS_UNABLE_TO_DELETE_SECTION,                                  0xC000001B, Errno::EPERM::Errno],
            [:STATUS_INVALID_SYSTEM_SERVICE,                                    0xC000001C, Errno::EPERM::Errno],
            [:STATUS_ILLEGAL_INSTRUCTION,                                       0xC000001D, Errno::EPERM::Errno],
            [:STATUS_INVALID_LOCK_SEQUENCE,                                     0xC000001E, Errno::EPERM::Errno],
            [:STATUS_INVALID_VIEW_SIZE,                                         0xC000001F, Errno::EPERM::Errno],
            [:STATUS_INVALID_FILE_FOR_SECTION,                                  0xC0000020, Errno::EPERM::Errno],
            [:STATUS_ALREADY_COMMITTED,                                         0xC0000021, Errno::EPERM::Errno],
            [:STATUS_ACCESS_DENIED,                                             0xC0000022, Errno::EPERM::Errno],
            [:STATUS_BUFFER_TOO_SMALL,                                          0xC0000023, Errno::EPERM::Errno],
            [:STATUS_OBJECT_TYPE_MISMATCH,                                      0xC0000024, Errno::EPERM::Errno],
            [:STATUS_NONCONTINUABLE_EXCEPTION,                                  0xC0000025, Errno::EPERM::Errno],
            [:STATUS_INVALID_DISPOSITION,                                       0xC0000026, Errno::EPERM::Errno],
            [:STATUS_UNWIND,                                                    0xC0000027, Errno::EPERM::Errno],
            [:STATUS_BAD_STACK,                                                 0xC0000028, Errno::EPERM::Errno],
            [:STATUS_INVALID_UNWIND_TARGET,                                     0xC0000029, Errno::EPERM::Errno],
            [:STATUS_NOT_LOCKED,                                                0xC000002A, Errno::EPERM::Errno],
            [:STATUS_PARITY_ERROR,                                              0xC000002B, Errno::EPERM::Errno],
            [:STATUS_UNABLE_TO_DECOMMIT_VM,                                     0xC000002C, Errno::EPERM::Errno],
            [:STATUS_NOT_COMMITTED,                                             0xC000002D, Errno::EPERM::Errno],
            [:STATUS_INVALID_PORT_ATTRIBUTES,                                   0xC000002E, Errno::EPERM::Errno],
            [:STATUS_PORT_MESSAGE_TOO_LONG,                                     0xC000002F, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_MIX,                                     0xC0000030, Errno::EPERM::Errno],
            [:STATUS_INVALID_QUOTA_LOWER,                                       0xC0000031, Errno::EPERM::Errno],
            [:STATUS_DISK_CORRUPT_ERROR,                                        0xC0000032, Errno::EPERM::Errno],
            [:STATUS_OBJECT_NAME_INVALID,                                       0xC0000033, Errno::ENOENT::Errno],
            [:STATUS_OBJECT_NAME_NOT_FOUND,                                     0xC0000034, Errno::ENOENT::Errno],
            [:STATUS_OBJECT_NAME_COLLISION,                                     0xC0000035, Errno::EPERM::Errno],
            [:STATUS_PORT_DISCONNECTED,                                         0xC0000037, Errno::EPERM::Errno],
            [:STATUS_DEVICE_ALREADY_ATTACHED,                                   0xC0000038, Errno::EPERM::Errno],
            [:STATUS_OBJECT_PATH_INVALID,                                       0xC0000039, Errno::EPERM::Errno],
            [:STATUS_OBJECT_PATH_NOT_FOUND,                                     0xC000003A, Errno::EPERM::Errno],
            [:STATUS_OBJECT_PATH_SYNTAX_BAD,                                    0xC000003B, Errno::EPERM::Errno],
            [:STATUS_DATA_OVERRUN,                                              0xC000003C, Errno::EPERM::Errno],
            [:STATUS_DATA_LATE_ERROR,                                           0xC000003D, Errno::EPERM::Errno],
            [:STATUS_DATA_ERROR,                                                0xC000003E, Errno::EPERM::Errno],
            [:STATUS_CRC_ERROR,                                                 0xC000003F, Errno::EPERM::Errno],
            [:STATUS_SECTION_TOO_BIG,                                           0xC0000040, Errno::EPERM::Errno],
            [:STATUS_PORT_CONNECTION_REFUSED,                                   0xC0000041, Errno::EPERM::Errno],
            [:STATUS_INVALID_PORT_HANDLE,                                       0xC0000042, Errno::EPERM::Errno],
            [:STATUS_SHARING_VIOLATION,                                         0xC0000043, Errno::EPERM::Errno],
            [:STATUS_QUOTA_EXCEEDED,                                            0xC0000044, Errno::EPERM::Errno],
            [:STATUS_INVALID_PAGE_PROTECTION,                                   0xC0000045, Errno::EPERM::Errno],
            [:STATUS_MUTANT_NOT_OWNED,                                          0xC0000046, Errno::EPERM::Errno],
            [:STATUS_SEMAPHORE_LIMIT_EXCEEDED,                                  0xC0000047, Errno::EPERM::Errno],
            [:STATUS_PORT_ALREADY_SET,                                          0xC0000048, Errno::EPERM::Errno],
            [:STATUS_SECTION_NOT_IMAGE,                                         0xC0000049, Errno::EPERM::Errno],
            [:STATUS_SUSPEND_COUNT_EXCEEDED,                                    0xC000004A, Errno::EPERM::Errno],
            [:STATUS_THREAD_IS_TERMINATING,                                     0xC000004B, Errno::EPERM::Errno],
            [:STATUS_BAD_WORKING_SET_LIMIT,                                     0xC000004C, Errno::EPERM::Errno],
            [:STATUS_INCOMPATIBLE_FILE_MAP,                                     0xC000004D, Errno::EPERM::Errno],
            [:STATUS_SECTION_PROTECTION,                                        0xC000004E, Errno::EPERM::Errno],
            [:STATUS_EAS_NOT_SUPPORTED,                                         0xC000004F, Errno::EPERM::Errno],
            [:STATUS_EA_TOO_LARGE,                                              0xC0000050, Errno::EPERM::Errno],
            [:STATUS_NONEXISTENT_EA_ENTRY,                                      0xC0000051, Errno::EPERM::Errno],
            [:STATUS_NO_EAS_ON_FILE,                                            0xC0000052, Errno::EPERM::Errno],
            [:STATUS_EA_CORRUPT_ERROR,                                          0xC0000053, Errno::EPERM::Errno],
            [:STATUS_FILE_LOCK_CONFLICT,                                        0xC0000054, Errno::EPERM::Errno],
            [:STATUS_LOCK_NOT_GRANTED,                                          0xC0000055, Errno::EPERM::Errno],
            [:STATUS_DELETE_PENDING,                                            0xC0000056, Errno::EPERM::Errno],
            [:STATUS_CTL_FILE_NOT_SUPPORTED,                                    0xC0000057, Errno::EPERM::Errno],
            [:STATUS_UNKNOWN_REVISION,                                          0xC0000058, Errno::EPERM::Errno],
            [:STATUS_REVISION_MISMATCH,                                         0xC0000059, Errno::EPERM::Errno],
            [:STATUS_INVALID_OWNER,                                             0xC000005A, Errno::EPERM::Errno],
            [:STATUS_INVALID_PRIMARY_GROUP,                                     0xC000005B, Errno::EPERM::Errno],
            [:STATUS_NO_IMPERSONATION_TOKEN,                                    0xC000005C, Errno::EPERM::Errno],
            [:STATUS_CANT_DISABLE_MANDATORY,                                    0xC000005D, Errno::EPERM::Errno],
            [:STATUS_NO_LOGON_SERVERS,                                          0xC000005E, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_LOGON_SESSION,                                     0xC000005F, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_PRIVILEGE,                                         0xC0000060, Errno::EPERM::Errno],
            [:STATUS_PRIVILEGE_NOT_HELD,                                        0xC0000061, Errno::EPERM::Errno],
            [:STATUS_INVALID_ACCOUNT_NAME,                                      0xC0000062, Errno::EPERM::Errno],
            [:STATUS_USER_EXISTS,                                               0xC0000063, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_USER,                                              0xC0000064, Errno::EPERM::Errno],
            [:STATUS_GROUP_EXISTS,                                              0xC0000065, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_GROUP,                                             0xC0000066, Errno::EPERM::Errno],
            [:STATUS_MEMBER_IN_GROUP,                                           0xC0000067, Errno::EPERM::Errno],
            [:STATUS_MEMBER_NOT_IN_GROUP,                                       0xC0000068, Errno::EPERM::Errno],
            [:STATUS_LAST_ADMIN,                                                0xC0000069, Errno::EPERM::Errno],
            [:STATUS_WRONG_PASSWORD,                                            0xC000006A, Errno::EPERM::Errno],
            [:STATUS_ILL_FORMED_PASSWORD,                                       0xC000006B, Errno::EPERM::Errno],
            [:STATUS_PASSWORD_RESTRICTION,                                      0xC000006C, Errno::EPERM::Errno],
            [:STATUS_LOGON_FAILURE,                                             0xC000006D, Errno::EPERM::Errno],
            [:STATUS_ACCOUNT_RESTRICTION,                                       0xC000006E, Errno::EPERM::Errno],
            [:STATUS_INVALID_LOGON_HOURS,                                       0xC000006F, Errno::EPERM::Errno],
            [:STATUS_INVALID_WORKSTATION,                                       0xC0000070, Errno::EPERM::Errno],
            [:STATUS_PASSWORD_EXPIRED,                                          0xC0000071, Errno::EPERM::Errno],
            [:STATUS_ACCOUNT_DISABLED,                                          0xC0000072, Errno::EPERM::Errno],
            [:STATUS_NONE_MAPPED,                                               0xC0000073, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_LUIDS_REQUESTED,                                  0xC0000074, Errno::EPERM::Errno],
            [:STATUS_LUIDS_EXHAUSTED,                                           0xC0000075, Errno::EPERM::Errno],
            [:STATUS_INVALID_SUB_AUTHORITY,                                     0xC0000076, Errno::EPERM::Errno],
            [:STATUS_INVALID_ACL,                                               0xC0000077, Errno::EPERM::Errno],
            [:STATUS_INVALID_SID,                                               0xC0000078, Errno::EPERM::Errno],
            [:STATUS_INVALID_SECURITY_DESCR,                                    0xC0000079, Errno::EPERM::Errno],
            [:STATUS_PROCEDURE_NOT_FOUND,                                       0xC000007A, Errno::EPERM::Errno],
            [:STATUS_INVALID_IMAGE_FORMAT,                                      0xC000007B, Errno::EPERM::Errno],
            [:STATUS_NO_TOKEN,                                                  0xC000007C, Errno::EPERM::Errno],
            [:STATUS_BAD_INHERITANCE_ACL,                                       0xC000007D, Errno::EPERM::Errno],
            [:STATUS_RANGE_NOT_LOCKED,                                          0xC000007E, Errno::EPERM::Errno],
            [:STATUS_DISK_FULL,                                                 0xC000007F, Errno::EPERM::Errno],
            [:STATUS_SERVER_DISABLED,                                           0xC0000080, Errno::EPERM::Errno],
            [:STATUS_SERVER_NOT_DISABLED,                                       0xC0000081, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_GUIDS_REQUESTED,                                  0xC0000082, Errno::EPERM::Errno],
            [:STATUS_GUIDS_EXHAUSTED,                                           0xC0000083, Errno::EPERM::Errno],
            [:STATUS_INVALID_ID_AUTHORITY,                                      0xC0000084, Errno::EPERM::Errno],
            [:STATUS_AGENTS_EXHAUSTED,                                          0xC0000085, Errno::EPERM::Errno],
            [:STATUS_INVALID_VOLUME_LABEL,                                      0xC0000086, Errno::EPERM::Errno],
            [:STATUS_SECTION_NOT_EXTENDED,                                      0xC0000087, Errno::EPERM::Errno],
            [:STATUS_NOT_MAPPED_DATA,                                           0xC0000088, Errno::EPERM::Errno],
            [:STATUS_RESOURCE_DATA_NOT_FOUND,                                   0xC0000089, Errno::EPERM::Errno],
            [:STATUS_RESOURCE_TYPE_NOT_FOUND,                                   0xC000008A, Errno::EPERM::Errno],
            [:STATUS_RESOURCE_NAME_NOT_FOUND,                                   0xC000008B, Errno::EPERM::Errno],
            [:STATUS_ARRAY_BOUNDS_EXCEEDED,                                     0xC000008C, Errno::EPERM::Errno],
            [:STATUS_FLOAT_DENORMAL_OPERAND,                                    0xC000008D, Errno::EPERM::Errno],
            [:STATUS_FLOAT_DIVIDE_BY_ZERO,                                      0xC000008E, Errno::EPERM::Errno],
            [:STATUS_FLOAT_INEXACT_RESULT,                                      0xC000008F, Errno::EPERM::Errno],
            [:STATUS_FLOAT_INVALID_OPERATION,                                   0xC0000090, Errno::EPERM::Errno],
            [:STATUS_FLOAT_OVERFLOW,                                            0xC0000091, Errno::EPERM::Errno],
            [:STATUS_FLOAT_STACK_CHECK,                                         0xC0000092, Errno::EPERM::Errno],
            [:STATUS_FLOAT_UNDERFLOW,                                           0xC0000093, Errno::EPERM::Errno],
            [:STATUS_INTEGER_DIVIDE_BY_ZERO,                                    0xC0000094, Errno::EPERM::Errno],
            [:STATUS_INTEGER_OVERFLOW,                                          0xC0000095, Errno::EPERM::Errno],
            [:STATUS_PRIVILEGED_INSTRUCTION,                                    0xC0000096, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_PAGING_FILES,                                     0xC0000097, Errno::EPERM::Errno],
            [:STATUS_FILE_INVALID,                                              0xC0000098, Errno::EPERM::Errno],
            [:STATUS_ALLOTTED_SPACE_EXCEEDED,                                   0xC0000099, Errno::EPERM::Errno],
            [:STATUS_INSUFFICIENT_RESOURCES,                                    0xC000009A, Errno::EPERM::Errno],
            [:STATUS_DFS_EXIT_PATH_FOUND,                                       0xC000009B, Errno::EPERM::Errno],
            [:STATUS_DEVICE_DATA_ERROR,                                         0xC000009C, Errno::EPERM::Errno],
            [:STATUS_DEVICE_NOT_CONNECTED,                                      0xC000009D, Errno::EPERM::Errno],
            [:STATUS_DEVICE_POWER_FAILURE,                                      0xC000009E, Errno::EPERM::Errno],
            [:STATUS_FREE_VM_NOT_AT_BASE,                                       0xC000009F, Errno::EPERM::Errno],
            [:STATUS_MEMORY_NOT_ALLOCATED,                                      0xC00000A0, Errno::EPERM::Errno],
            [:STATUS_WORKING_SET_QUOTA,                                         0xC00000A1, Errno::EPERM::Errno],
            [:STATUS_MEDIA_WRITE_PROTECTED,                                     0xC00000A2, Errno::EPERM::Errno],
            [:STATUS_DEVICE_NOT_READY,                                          0xC00000A3, Errno::EPERM::Errno],
            [:STATUS_INVALID_GROUP_ATTRIBUTES,                                  0xC00000A4, Errno::EPERM::Errno],
            [:STATUS_BAD_IMPERSONATION_LEVEL,                                   0xC00000A5, Errno::EPERM::Errno],
            [:STATUS_CANT_OPEN_ANONYMOUS,                                       0xC00000A6, Errno::EPERM::Errno],
            [:STATUS_BAD_VALIDATION_CLASS,                                      0xC00000A7, Errno::EPERM::Errno],
            [:STATUS_BAD_TOKEN_TYPE,                                            0xC00000A8, Errno::EPERM::Errno],
            [:STATUS_BAD_MASTER_BOOT_RECORD,                                    0xC00000A9, Errno::EPERM::Errno],
            [:STATUS_INSTRUCTION_MISALIGNMENT,                                  0xC00000AA, Errno::EPERM::Errno],
            [:STATUS_INSTANCE_NOT_AVAILABLE,                                    0xC00000AB, Errno::EPERM::Errno],
            [:STATUS_PIPE_NOT_AVAILABLE,                                        0xC00000AC, Errno::EPERM::Errno],
            [:STATUS_INVALID_PIPE_STATE,                                        0xC00000AD, Errno::EPERM::Errno],
            [:STATUS_PIPE_BUSY,                                                 0xC00000AE, Errno::EPERM::Errno],
            [:STATUS_ILLEGAL_FUNCTION,                                          0xC00000AF, Errno::EPERM::Errno],
            [:STATUS_PIPE_DISCONNECTED,                                         0xC00000B0, Errno::EPERM::Errno],
            [:STATUS_PIPE_CLOSING,                                              0xC00000B1, Errno::EPERM::Errno],
            [:STATUS_PIPE_CONNECTED,                                            0xC00000B2, Errno::EPERM::Errno],
            [:STATUS_PIPE_LISTENING,                                            0xC00000B3, Errno::EPERM::Errno],
            [:STATUS_INVALID_READ_MODE,                                         0xC00000B4, Errno::EPERM::Errno],
            [:STATUS_IO_TIMEOUT,                                                0xC00000B5, Errno::EPERM::Errno],
            [:STATUS_FILE_FORCED_CLOSED,                                        0xC00000B6, Errno::EPERM::Errno],
            [:STATUS_PROFILING_NOT_STARTED,                                     0xC00000B7, Errno::EPERM::Errno],
            [:STATUS_PROFILING_NOT_STOPPED,                                     0xC00000B8, Errno::EPERM::Errno],
            [:STATUS_COULD_NOT_INTERPRET,                                       0xC00000B9, Errno::EPERM::Errno],
            [:STATUS_FILE_IS_A_DIRECTORY,                                       0xC00000BA, Errno::EPERM::Errno],
            [:STATUS_NOT_SUPPORTED,                                             0xC00000BB, Errno::EPERM::Errno],
            [:STATUS_REMOTE_NOT_LISTENING,                                      0xC00000BC, Errno::EPERM::Errno],
            [:STATUS_DUPLICATE_NAME,                                            0xC00000BD, Errno::EPERM::Errno],
            [:STATUS_BAD_NETWORK_PATH,                                          0xC00000BE, Errno::EPERM::Errno],
            [:STATUS_NETWORK_BUSY,                                              0xC00000BF, Errno::EPERM::Errno],
            [:STATUS_DEVICE_DOES_NOT_EXIST,                                     0xC00000C0, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_COMMANDS,                                         0xC00000C1, Errno::EPERM::Errno],
            [:STATUS_ADAPTER_HARDWARE_ERROR,                                    0xC00000C2, Errno::EPERM::Errno],
            [:STATUS_INVALID_NETWORK_RESPONSE,                                  0xC00000C3, Errno::EPERM::Errno],
            [:STATUS_UNEXPECTED_NETWORK_ERROR,                                  0xC00000C4, Errno::EPERM::Errno],
            [:STATUS_BAD_REMOTE_ADAPTER,                                        0xC00000C5, Errno::EPERM::Errno],
            [:STATUS_PRINT_QUEUE_FULL,                                          0xC00000C6, Errno::EPERM::Errno],
            [:STATUS_NO_SPOOL_SPACE,                                            0xC00000C7, Errno::EPERM::Errno],
            [:STATUS_PRINT_CANCELLED,                                           0xC00000C8, Errno::EPERM::Errno],
            [:STATUS_NETWORK_NAME_DELETED,                                      0xC00000C9, Errno::EPERM::Errno],
            [:STATUS_NETWORK_ACCESS_DENIED,                                     0xC00000CA, Errno::EPERM::Errno],
            [:STATUS_BAD_DEVICE_TYPE,                                           0xC00000CB, Errno::EPERM::Errno],
            [:STATUS_BAD_NETWORK_NAME,                                          0xC00000CC, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_NAMES,                                            0xC00000CD, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_SESSIONS,                                         0xC00000CE, Errno::EPERM::Errno],
            [:STATUS_SHARING_PAUSED,                                            0xC00000CF, Errno::EPERM::Errno],
            [:STATUS_REQUEST_NOT_ACCEPTED,                                      0xC00000D0, Errno::EPERM::Errno],
            [:STATUS_REDIRECTOR_PAUSED,                                         0xC00000D1, Errno::EPERM::Errno],
            [:STATUS_NET_WRITE_FAULT,                                           0xC00000D2, Errno::EPERM::Errno],
            [:STATUS_PROFILING_AT_LIMIT,                                        0xC00000D3, Errno::EPERM::Errno],
            [:STATUS_NOT_SAME_DEVICE,                                           0xC00000D4, Errno::EPERM::Errno],
            [:STATUS_FILE_RENAMED,                                              0xC00000D5, Errno::EPERM::Errno],
            [:STATUS_VIRTUAL_CIRCUIT_CLOSED,                                    0xC00000D6, Errno::EPERM::Errno],
            [:STATUS_NO_SECURITY_ON_OBJECT,                                     0xC00000D7, Errno::EPERM::Errno],
            [:STATUS_CANT_WAIT,                                                 0xC00000D8, Errno::EPERM::Errno],
            [:STATUS_PIPE_EMPTY,                                                0xC00000D9, Errno::EPERM::Errno],
            [:STATUS_CANT_ACCESS_DOMAIN_INFO,                                   0xC00000DA, Errno::EPERM::Errno],
            [:STATUS_CANT_TERMINATE_SELF,                                       0xC00000DB, Errno::EPERM::Errno],
            [:STATUS_INVALID_SERVER_STATE,                                      0xC00000DC, Errno::EPERM::Errno],
            [:STATUS_INVALID_DOMAIN_STATE,                                      0xC00000DD, Errno::EPERM::Errno],
            [:STATUS_INVALID_DOMAIN_ROLE,                                       0xC00000DE, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_DOMAIN,                                            0xC00000DF, Errno::EPERM::Errno],
            [:STATUS_DOMAIN_EXISTS,                                             0xC00000E0, Errno::EPERM::Errno],
            [:STATUS_DOMAIN_LIMIT_EXCEEDED,                                     0xC00000E1, Errno::EPERM::Errno],
            [:STATUS_OPLOCK_NOT_GRANTED,                                        0xC00000E2, Errno::EPERM::Errno],
            [:STATUS_INVALID_OPLOCK_PROTOCOL,                                   0xC00000E3, Errno::EPERM::Errno],
            [:STATUS_INTERNAL_DB_CORRUPTION,                                    0xC00000E4, Errno::EPERM::Errno],
            [:STATUS_INTERNAL_ERROR,                                            0xC00000E5, Errno::EPERM::Errno],
            [:STATUS_GENERIC_NOT_MAPPED,                                        0xC00000E6, Errno::EPERM::Errno],
            [:STATUS_BAD_DESCRIPTOR_FORMAT,                                     0xC00000E7, Errno::EPERM::Errno],
            [:STATUS_INVALID_USER_BUFFER,                                       0xC00000E8, Errno::EPERM::Errno],
            [:STATUS_UNEXPECTED_IO_ERROR,                                       0xC00000E9, Errno::EPERM::Errno],
            [:STATUS_UNEXPECTED_MM_CREATE_ERR,                                  0xC00000EA, Errno::EPERM::Errno],
            [:STATUS_UNEXPECTED_MM_MAP_ERROR,                                   0xC00000EB, Errno::EPERM::Errno],
            [:STATUS_UNEXPECTED_MM_EXTEND_ERR,                                  0xC00000EC, Errno::EPERM::Errno],
            [:STATUS_NOT_LOGON_PROCESS,                                         0xC00000ED, Errno::EPERM::Errno],
            [:STATUS_LOGON_SESSION_EXISTS,                                      0xC00000EE, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_1,                                       0xC00000EF, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_2,                                       0xC00000F0, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_3,                                       0xC00000F1, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_4,                                       0xC00000F2, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_5,                                       0xC00000F3, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_6,                                       0xC00000F4, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_7,                                       0xC00000F5, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_8,                                       0xC00000F6, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_9,                                       0xC00000F7, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_10,                                      0xC00000F8, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_11,                                      0xC00000F9, Errno::EPERM::Errno],
            [:STATUS_INVALID_PARAMETER_12,                                      0xC00000FA, Errno::EPERM::Errno],
            [:STATUS_REDIRECTOR_NOT_STARTED,                                    0xC00000FB, Errno::EPERM::Errno],
            [:STATUS_REDIRECTOR_STARTED,                                        0xC00000FC, Errno::EPERM::Errno],
            [:STATUS_STACK_OVERFLOW,                                            0xC00000FD, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_PACKAGE,                                           0xC00000FE, Errno::EPERM::Errno],
            [:STATUS_BAD_FUNCTION_TABLE,                                        0xC00000FF, Errno::EPERM::Errno],
            [:STATUS_VARIABLE_NOT_FOUND,                                        0xC0000100, Errno::EPERM::Errno],
            [:STATUS_DIRECTORY_NOT_EMPTY,                                       0xC0000101, Errno::EPERM::Errno],
            [:STATUS_FILE_CORRUPT_ERROR,                                        0xC0000102, Errno::EPERM::Errno],
            [:STATUS_NOT_A_DIRECTORY,                                           0xC0000103, Errno::EPERM::Errno],
            [:STATUS_BAD_LOGON_SESSION_STATE,                                   0xC0000104, Errno::EPERM::Errno],
            [:STATUS_LOGON_SESSION_COLLISION,                                   0xC0000105, Errno::EPERM::Errno],
            [:STATUS_NAME_TOO_LONG,                                             0xC0000106, Errno::EPERM::Errno],
            [:STATUS_FILES_OPEN,                                                0xC0000107, Errno::EPERM::Errno],
            [:STATUS_CONNECTION_IN_USE,                                         0xC0000108, Errno::EPERM::Errno],
            [:STATUS_MESSAGE_NOT_FOUND,                                         0xC0000109, Errno::EPERM::Errno],
            [:STATUS_PROCESS_IS_TERMINATING,                                    0xC000010A, Errno::EPERM::Errno],
            [:STATUS_INVALID_LOGON_TYPE,                                        0xC000010B, Errno::EPERM::Errno],
            [:STATUS_NO_GUID_TRANSLATION,                                       0xC000010C, Errno::EPERM::Errno],
            [:STATUS_CANNOT_IMPERSONATE,                                        0xC000010D, Errno::EPERM::Errno],
            [:STATUS_IMAGE_ALREADY_LOADED,                                      0xC000010E, Errno::EPERM::Errno],
            [:STATUS_ABIOS_NOT_PRESENT,                                         0xC000010F, Errno::EPERM::Errno],
            [:STATUS_ABIOS_LID_NOT_EXIST,                                       0xC0000110, Errno::EPERM::Errno],
            [:STATUS_ABIOS_LID_ALREADY_OWNED,                                   0xC0000111, Errno::EPERM::Errno],
            [:STATUS_ABIOS_NOT_LID_OWNER,                                       0xC0000112, Errno::EPERM::Errno],
            [:STATUS_ABIOS_INVALID_COMMAND,                                     0xC0000113, Errno::EPERM::Errno],
            [:STATUS_ABIOS_INVALID_LID,                                         0xC0000114, Errno::EPERM::Errno],
            [:STATUS_ABIOS_SELECTOR_NOT_AVAILABLE,                              0xC0000115, Errno::EPERM::Errno],
            [:STATUS_ABIOS_INVALID_SELECTOR,                                    0xC0000116, Errno::EPERM::Errno],
            [:STATUS_NO_LDT,                                                    0xC0000117, Errno::EPERM::Errno],
            [:STATUS_INVALID_LDT_SIZE,                                          0xC0000118, Errno::EPERM::Errno],
            [:STATUS_INVALID_LDT_OFFSET,                                        0xC0000119, Errno::EPERM::Errno],
            [:STATUS_INVALID_LDT_DESCRIPTOR,                                    0xC000011A, Errno::EPERM::Errno],
            [:STATUS_INVALID_IMAGE_NE_FORMAT,                                   0xC000011B, Errno::EPERM::Errno],
            [:STATUS_RXACT_INVALID_STATE,                                       0xC000011C, Errno::EPERM::Errno],
            [:STATUS_RXACT_COMMIT_FAILURE,                                      0xC000011D, Errno::EPERM::Errno],
            [:STATUS_MAPPED_FILE_SIZE_ZERO,                                     0xC000011E, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_OPENED_FILES,                                     0xC000011F, Errno::EPERM::Errno],
            [:STATUS_CANCELLED,                                                 0xC0000120, Errno::EPERM::Errno],
            [:STATUS_CANNOT_DELETE,                                             0xC0000121, Errno::EPERM::Errno],
            [:STATUS_INVALID_COMPUTER_NAME,                                     0xC0000122, Errno::EPERM::Errno],
            [:STATUS_FILE_DELETED,                                              0xC0000123, Errno::EPERM::Errno],
            [:STATUS_SPECIAL_ACCOUNT,                                           0xC0000124, Errno::EPERM::Errno],
            [:STATUS_SPECIAL_GROUP,                                             0xC0000125, Errno::EPERM::Errno],
            [:STATUS_SPECIAL_USER,                                              0xC0000126, Errno::EPERM::Errno],
            [:STATUS_MEMBERS_PRIMARY_GROUP,                                     0xC0000127, Errno::EPERM::Errno],
            [:STATUS_FILE_CLOSED,                                               0xC0000128, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_THREADS,                                          0xC0000129, Errno::EPERM::Errno],
            [:STATUS_THREAD_NOT_IN_PROCESS,                                     0xC000012A, Errno::EPERM::Errno],
            [:STATUS_TOKEN_ALREADY_IN_USE,                                      0xC000012B, Errno::EPERM::Errno],
            [:STATUS_PAGEFILE_QUOTA_EXCEEDED,                                   0xC000012C, Errno::EPERM::Errno],
            [:STATUS_COMMITMENT_LIMIT,                                          0xC000012D, Errno::EPERM::Errno],
            [:STATUS_INVALID_IMAGE_LE_FORMAT,                                   0xC000012E, Errno::EPERM::Errno],
            [:STATUS_INVALID_IMAGE_NOT_MZ,                                      0xC000012F, Errno::EPERM::Errno],
            [:STATUS_INVALID_IMAGE_PROTECT,                                     0xC0000130, Errno::EPERM::Errno],
            [:STATUS_INVALID_IMAGE_WIN_16,                                      0xC0000131, Errno::EPERM::Errno],
            [:STATUS_LOGON_SERVER_CONFLICT,                                     0xC0000132, Errno::EPERM::Errno],
            [:STATUS_TIME_DIFFERENCE_AT_DC,                                     0xC0000133, Errno::EPERM::Errno],
            [:STATUS_SYNCHRONIZATION_REQUIRED,                                  0xC0000134, Errno::EPERM::Errno],
            [:STATUS_DLL_NOT_FOUND,                                             0xC0000135, Errno::EPERM::Errno],
            [:STATUS_OPEN_FAILED,                                               0xC0000136, Errno::EPERM::Errno],
            [:STATUS_IO_PRIVILEGE_FAILED,                                       0xC0000137, Errno::EPERM::Errno],
            [:STATUS_ORDINAL_NOT_FOUND,                                         0xC0000138, Errno::EPERM::Errno],
            [:STATUS_ENTRYPOINT_NOT_FOUND,                                      0xC0000139, Errno::EPERM::Errno],
            [:STATUS_CONTROL_C_EXIT,                                            0xC000013A, Errno::EPERM::Errno],
            [:STATUS_LOCAL_DISCONNECT,                                          0xC000013B, Errno::EPERM::Errno],
            [:STATUS_REMOTE_DISCONNECT,                                         0xC000013C, Errno::EPERM::Errno],
            [:STATUS_REMOTE_RESOURCES,                                          0xC000013D, Errno::EPERM::Errno],
            [:STATUS_LINK_FAILED,                                               0xC000013E, Errno::EPERM::Errno],
            [:STATUS_LINK_TIMEOUT,                                              0xC000013F, Errno::EPERM::Errno],
            [:STATUS_INVALID_CONNECTION,                                        0xC0000140, Errno::EPERM::Errno],
            [:STATUS_INVALID_ADDRESS,                                           0xC0000141, Errno::EPERM::Errno],
            [:STATUS_DLL_INIT_FAILED,                                           0xC0000142, Errno::EPERM::Errno],
            [:STATUS_MISSING_SYSTEMFILE,                                        0xC0000143, Errno::EPERM::Errno],
            [:STATUS_UNHANDLED_EXCEPTION,                                       0xC0000144, Errno::EPERM::Errno],
            [:STATUS_APP_INIT_FAILURE,                                          0xC0000145, Errno::EPERM::Errno],
            [:STATUS_PAGEFILE_CREATE_FAILED,                                    0xC0000146, Errno::EPERM::Errno],
            [:STATUS_NO_PAGEFILE,                                               0xC0000147, Errno::EPERM::Errno],
            [:STATUS_INVALID_LEVEL,                                             0xC0000148, Errno::EPERM::Errno],
            [:STATUS_WRONG_PASSWORD_CORE,                                       0xC0000149, Errno::EPERM::Errno],
            [:STATUS_ILLEGAL_FLOAT_CONTEXT,                                     0xC000014A, Errno::EPERM::Errno],
            [:STATUS_PIPE_BROKEN,                                               0xC000014B, Errno::EPERM::Errno],
            [:STATUS_REGISTRY_CORRUPT,                                          0xC000014C, Errno::EPERM::Errno],
            [:STATUS_REGISTRY_IO_FAILED,                                        0xC000014D, Errno::EPERM::Errno],
            [:STATUS_NO_EVENT_PAIR,                                             0xC000014E, Errno::EPERM::Errno],
            [:STATUS_UNRECOGNIZED_VOLUME,                                       0xC000014F, Errno::EPERM::Errno],
            [:STATUS_SERIAL_NO_DEVICE_INITED,                                   0xC0000150, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_ALIAS,                                             0xC0000151, Errno::EPERM::Errno],
            [:STATUS_MEMBER_NOT_IN_ALIAS,                                       0xC0000152, Errno::EPERM::Errno],
            [:STATUS_MEMBER_IN_ALIAS,                                           0xC0000153, Errno::EPERM::Errno],
            [:STATUS_ALIAS_EXISTS,                                              0xC0000154, Errno::EPERM::Errno],
            [:STATUS_LOGON_NOT_GRANTED,                                         0xC0000155, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_SECRETS,                                          0xC0000156, Errno::EPERM::Errno],
            [:STATUS_SECRET_TOO_LONG,                                           0xC0000157, Errno::EPERM::Errno],
            [:STATUS_INTERNAL_DB_ERROR,                                         0xC0000158, Errno::EPERM::Errno],
            [:STATUS_FULLSCREEN_MODE,                                           0xC0000159, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_CONTEXT_IDS,                                      0xC000015A, Errno::EPERM::Errno],
            [:STATUS_LOGON_TYPE_NOT_GRANTED,                                    0xC000015B, Errno::EPERM::Errno],
            [:STATUS_NOT_REGISTRY_FILE,                                         0xC000015C, Errno::EPERM::Errno],
            [:STATUS_NT_CROSS_ENCRYPTION_REQUIRED,                              0xC000015D, Errno::EPERM::Errno],
            [:STATUS_DOMAIN_CTRLR_CONFIG_ERROR,                                 0xC000015E, Errno::EPERM::Errno],
            [:STATUS_FT_MISSING_MEMBER,                                         0xC000015F, Errno::EPERM::Errno],
            [:STATUS_ILL_FORMED_SERVICE_ENTRY,                                  0xC0000160, Errno::EPERM::Errno],
            [:STATUS_ILLEGAL_CHARACTER,                                         0xC0000161, Errno::EPERM::Errno],
            [:STATUS_UNMAPPABLE_CHARACTER,                                      0xC0000162, Errno::EPERM::Errno],
            [:STATUS_UNDEFINED_CHARACTER,                                       0xC0000163, Errno::EPERM::Errno],
            [:STATUS_FLOPPY_VOLUME,                                             0xC0000164, Errno::EPERM::Errno],
            [:STATUS_FLOPPY_ID_MARK_NOT_FOUND,                                  0xC0000165, Errno::EPERM::Errno],
            [:STATUS_FLOPPY_WRONG_CYLINDER,                                     0xC0000166, Errno::EPERM::Errno],
            [:STATUS_FLOPPY_UNKNOWN_ERROR,                                      0xC0000167, Errno::EPERM::Errno],
            [:STATUS_FLOPPY_BAD_REGISTERS,                                      0xC0000168, Errno::EPERM::Errno],
            [:STATUS_DISK_RECALIBRATE_FAILED,                                   0xC0000169, Errno::EPERM::Errno],
            [:STATUS_DISK_OPERATION_FAILED,                                     0xC000016A, Errno::EPERM::Errno],
            [:STATUS_DISK_RESET_FAILED,                                         0xC000016B, Errno::EPERM::Errno],
            [:STATUS_SHARED_IRQ_BUSY,                                           0xC000016C, Errno::EPERM::Errno],
            [:STATUS_FT_ORPHANING,                                              0xC000016D, Errno::EPERM::Errno],
            [:STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT,                          0xC000016E, Errno::EPERM::Errno],
            [:STATUS_PARTITION_FAILURE,                                         0xC0000172, Errno::EPERM::Errno],
            [:STATUS_INVALID_BLOCK_LENGTH,                                      0xC0000173, Errno::EPERM::Errno],
            [:STATUS_DEVICE_NOT_PARTITIONED,                                    0xC0000174, Errno::EPERM::Errno],
            [:STATUS_UNABLE_TO_LOCK_MEDIA,                                      0xC0000175, Errno::EPERM::Errno],
            [:STATUS_UNABLE_TO_UNLOAD_MEDIA,                                    0xC0000176, Errno::EPERM::Errno],
            [:STATUS_EOM_OVERFLOW,                                              0xC0000177, Errno::EPERM::Errno],
            [:STATUS_NO_MEDIA,                                                  0xC0000178, Errno::EPERM::Errno],
            [:STATUS_NO_SUCH_MEMBER,                                            0xC000017A, Errno::EPERM::Errno],
            [:STATUS_INVALID_MEMBER,                                            0xC000017B, Errno::EPERM::Errno],
            [:STATUS_KEY_DELETED,                                               0xC000017C, Errno::EPERM::Errno],
            [:STATUS_NO_LOG_SPACE,                                              0xC000017D, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_SIDS,                                             0xC000017E, Errno::EPERM::Errno],
            [:STATUS_LM_CROSS_ENCRYPTION_REQUIRED,                              0xC000017F, Errno::EPERM::Errno],
            [:STATUS_KEY_HAS_CHILDREN,                                          0xC0000180, Errno::EPERM::Errno],
            [:STATUS_CHILD_MUST_BE_VOLATILE,                                    0xC0000181, Errno::EPERM::Errno],
            [:STATUS_DEVICE_CONFIGURATION_ERROR,                                0xC0000182, Errno::EPERM::Errno],
            [:STATUS_DRIVER_INTERNAL_ERROR,                                     0xC0000183, Errno::EPERM::Errno],
            [:STATUS_INVALID_DEVICE_STATE,                                      0xC0000184, Errno::EPERM::Errno],
            [:STATUS_IO_DEVICE_ERROR,                                           0xC0000185, Errno::EPERM::Errno],
            [:STATUS_DEVICE_PROTOCOL_ERROR,                                     0xC0000186, Errno::EPERM::Errno],
            [:STATUS_BACKUP_CONTROLLER,                                         0xC0000187, Errno::EPERM::Errno],
            [:STATUS_LOG_FILE_FULL,                                             0xC0000188, Errno::EPERM::Errno],
            [:STATUS_TOO_LATE,                                                  0xC0000189, Errno::EPERM::Errno],
            [:STATUS_NO_TRUST_LSA_SECRET,                                       0xC000018A, Errno::EPERM::Errno],
            [:STATUS_NO_TRUST_SAM_ACCOUNT,                                      0xC000018B, Errno::EPERM::Errno],
            [:STATUS_TRUSTED_DOMAIN_FAILURE,                                    0xC000018C, Errno::EPERM::Errno],
            [:STATUS_TRUSTED_RELATIONSHIP_FAILURE,                              0xC000018D, Errno::EPERM::Errno],
            [:STATUS_EVENTLOG_FILE_CORRUPT,                                     0xC000018E, Errno::EPERM::Errno],
            [:STATUS_EVENTLOG_CANT_START,                                       0xC000018F, Errno::EPERM::Errno],
            [:STATUS_TRUST_FAILURE,                                             0xC0000190, Errno::EPERM::Errno],
            [:STATUS_MUTANT_LIMIT_EXCEEDED,                                     0xC0000191, Errno::EPERM::Errno],
            [:STATUS_NETLOGON_NOT_STARTED,                                      0xC0000192, Errno::EPERM::Errno],
            [:STATUS_ACCOUNT_EXPIRED,                                           0xC0000193, Errno::EPERM::Errno],
            [:STATUS_POSSIBLE_DEADLOCK,                                         0xC0000194, Errno::EPERM::Errno],
            [:STATUS_NETWORK_CREDENTIAL_CONFLICT,                               0xC0000195, Errno::EPERM::Errno],
            [:STATUS_REMOTE_SESSION_LIMIT,                                      0xC0000196, Errno::EPERM::Errno],
            [:STATUS_EVENTLOG_FILE_CHANGED,                                     0xC0000197, Errno::EPERM::Errno],
            [:STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT,                         0xC0000198, Errno::EPERM::Errno],
            [:STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT,                         0xC0000199, Errno::EPERM::Errno],
            [:STATUS_NOLOGON_SERVER_TRUST_ACCOUNT,                              0xC000019A, Errno::EPERM::Errno],
            [:STATUS_DOMAIN_TRUST_INCONSISTENT,                                 0xC000019B, Errno::EPERM::Errno],
            [:STATUS_FS_DRIVER_REQUIRED,                                        0xC000019C, Errno::EPERM::Errno],
            [:STATUS_NO_USER_SESSION_KEY,                                       0xC0000202, Errno::EPERM::Errno],
            [:STATUS_USER_SESSION_DELETED,                                      0xC0000203, Errno::EPERM::Errno],
            [:STATUS_RESOURCE_LANG_NOT_FOUND,                                   0xC0000204, Errno::EPERM::Errno],
            [:STATUS_INSUFF_SERVER_RESOURCES,                                   0xC0000205, Errno::EPERM::Errno],
            [:STATUS_INVALID_BUFFER_SIZE,                                       0xC0000206, Errno::EPERM::Errno],
            [:STATUS_INVALID_ADDRESS_COMPONENT,                                 0xC0000207, Errno::EPERM::Errno],
            [:STATUS_INVALID_ADDRESS_WILDCARD,                                  0xC0000208, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_ADDRESSES,                                        0xC0000209, Errno::EPERM::Errno],
            [:STATUS_ADDRESS_ALREADY_EXISTS,                                    0xC000020A, Errno::EPERM::Errno],
            [:STATUS_ADDRESS_CLOSED,                                            0xC000020B, Errno::EPERM::Errno],
            [:STATUS_CONNECTION_DISCONNECTED,                                   0xC000020C, Errno::EPERM::Errno],
            [:STATUS_CONNECTION_RESET,                                          0xC000020D, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_NODES,                                            0xC000020E, Errno::EPERM::Errno],
            [:STATUS_TRANSACTION_ABORTED,                                       0xC000020F, Errno::EPERM::Errno],
            [:STATUS_TRANSACTION_TIMED_OUT,                                     0xC0000210, Errno::EPERM::Errno],
            [:STATUS_TRANSACTION_NO_RELEASE,                                    0xC0000211, Errno::EPERM::Errno],
            [:STATUS_TRANSACTION_NO_MATCH,                                      0xC0000212, Errno::EPERM::Errno],
            [:STATUS_TRANSACTION_RESPONDED,                                     0xC0000213, Errno::EPERM::Errno],
            [:STATUS_TRANSACTION_INVALID_ID,                                    0xC0000214, Errno::EPERM::Errno],
            [:STATUS_TRANSACTION_INVALID_TYPE,                                  0xC0000215, Errno::EPERM::Errno],
            [:STATUS_NOT_SERVER_SESSION,                                        0xC0000216, Errno::EPERM::Errno],
            [:STATUS_NOT_CLIENT_SESSION,                                        0xC0000217, Errno::EPERM::Errno],
            [:STATUS_CANNOT_LOAD_REGISTRY_FILE,                                 0xC0000218, Errno::EPERM::Errno],
            [:STATUS_DEBUG_ATTACH_FAILED,                                       0xC0000219, Errno::EPERM::Errno],
            [:STATUS_SYSTEM_PROCESS_TERMINATED,                                 0xC000021A, Errno::EPERM::Errno],
            [:STATUS_DATA_NOT_ACCEPTED,                                         0xC000021B, Errno::EPERM::Errno],
            [:STATUS_NO_BROWSER_SERVERS_FOUND,                                  0xC000021C, Errno::EPERM::Errno],
            [:STATUS_VDM_HARD_ERROR,                                            0xC000021D, Errno::EPERM::Errno],
            [:STATUS_DRIVER_CANCEL_TIMEOUT,                                     0xC000021E, Errno::EPERM::Errno],
            [:STATUS_REPLY_MESSAGE_MISMATCH,                                    0xC000021F, Errno::EPERM::Errno],
            [:STATUS_MAPPED_ALIGNMENT,                                          0xC0000220, Errno::EPERM::Errno],
            [:STATUS_IMAGE_CHECKSUM_MISMATCH,                                   0xC0000221, Errno::EPERM::Errno],
            [:STATUS_LOST_WRITEBEHIND_DATA,                                     0xC0000222, Errno::EPERM::Errno],
            [:STATUS_CLIENT_SERVER_PARAMETERS_INVALID,                          0xC0000223, Errno::EPERM::Errno],
            [:STATUS_PASSWORD_MUST_CHANGE,                                      0xC0000224, Errno::EPERM::Errno],
            [:STATUS_NOT_FOUND,                                                 0xC0000225, Errno::EPERM::Errno],
            [:STATUS_NOT_TINY_STREAM,                                           0xC0000226, Errno::EPERM::Errno],
            [:STATUS_RECOVERY_FAILURE,                                          0xC0000227, Errno::EPERM::Errno],
            [:STATUS_STACK_OVERFLOW_READ,                                       0xC0000228, Errno::EPERM::Errno],
            [:STATUS_FAIL_CHECK,                                                0xC0000229, Errno::EPERM::Errno],
            [:STATUS_DUPLICATE_OBJECTID,                                        0xC000022A, Errno::EPERM::Errno],
            [:STATUS_OBJECTID_EXISTS,                                           0xC000022B, Errno::EPERM::Errno],
            [:STATUS_CONVERT_TO_LARGE,                                          0xC000022C, Errno::EPERM::Errno],
            [:STATUS_RETRY,                                                     0xC000022D, Errno::EPERM::Errno],
            [:STATUS_FOUND_OUT_OF_SCOPE,                                        0xC000022E, Errno::EPERM::Errno],
            [:STATUS_ALLOCATE_BUCKET,                                           0xC000022F, Errno::EPERM::Errno],
            [:STATUS_PROPSET_NOT_FOUND,                                         0xC0000230, Errno::EPERM::Errno],
            [:STATUS_MARSHALL_OVERFLOW,                                         0xC0000231, Errno::EPERM::Errno],
            [:STATUS_INVALID_VARIANT,                                           0xC0000232, Errno::EPERM::Errno],
            [:STATUS_DOMAIN_CONTROLLER_NOT_FOUND,                               0xC0000233, Errno::EPERM::Errno],
            [:STATUS_ACCOUNT_LOCKED_OUT,                                        0xC0000234, Errno::EPERM::Errno],
            [:STATUS_HANDLE_NOT_CLOSABLE,                                       0xC0000235, Errno::EPERM::Errno],
            [:STATUS_CONNECTION_REFUSED,                                        0xC0000236, Errno::EPERM::Errno],
            [:STATUS_GRACEFUL_DISCONNECT,                                       0xC0000237, Errno::EPERM::Errno],
            [:STATUS_ADDRESS_ALREADY_ASSOCIATED,                                0xC0000238, Errno::EPERM::Errno],
            [:STATUS_ADDRESS_NOT_ASSOCIATED,                                    0xC0000239, Errno::EPERM::Errno],
            [:STATUS_CONNECTION_INVALID,                                        0xC000023A, Errno::EPERM::Errno],
            [:STATUS_CONNECTION_ACTIVE,                                         0xC000023B, Errno::EPERM::Errno],
            [:STATUS_NETWORK_UNREACHABLE,                                       0xC000023C, Errno::EPERM::Errno],
            [:STATUS_HOST_UNREACHABLE,                                          0xC000023D, Errno::EPERM::Errno],
            [:STATUS_PROTOCOL_UNREACHABLE,                                      0xC000023E, Errno::EPERM::Errno],
            [:STATUS_PORT_UNREACHABLE,                                          0xC000023F, Errno::EPERM::Errno],
            [:STATUS_REQUEST_ABORTED,                                           0xC0000240, Errno::EPERM::Errno],
            [:STATUS_CONNECTION_ABORTED,                                        0xC0000241, Errno::EPERM::Errno],
            [:STATUS_BAD_COMPRESSION_BUFFER,                                    0xC0000242, Errno::EPERM::Errno],
            [:STATUS_USER_MAPPED_FILE,                                          0xC0000243, Errno::EPERM::Errno],
            [:STATUS_AUDIT_FAILED,                                              0xC0000244, Errno::EPERM::Errno],
            [:STATUS_TIMER_RESOLUTION_NOT_SET,                                  0xC0000245, Errno::EPERM::Errno],
            [:STATUS_CONNECTION_COUNT_LIMIT,                                    0xC0000246, Errno::EPERM::Errno],
            [:STATUS_LOGIN_TIME_RESTRICTION,                                    0xC0000247, Errno::EPERM::Errno],
            [:STATUS_LOGIN_WKSTA_RESTRICTION,                                   0xC0000248, Errno::EPERM::Errno],
            [:STATUS_IMAGE_MP_UP_MISMATCH,                                      0xC0000249, Errno::EPERM::Errno],
            [:STATUS_INSUFFICIENT_LOGON_INFO,                                   0xC0000250, Errno::EPERM::Errno],
            [:STATUS_BAD_DLL_ENTRYPOINT,                                        0xC0000251, Errno::EPERM::Errno],
            [:STATUS_BAD_SERVICE_ENTRYPOINT,                                    0xC0000252, Errno::EPERM::Errno],
            [:STATUS_LPC_REPLY_LOST,                                            0xC0000253, Errno::EPERM::Errno],
            [:STATUS_IP_ADDRESS_CONFLICT1,                                      0xC0000254, Errno::EPERM::Errno],
            [:STATUS_IP_ADDRESS_CONFLICT2,                                      0xC0000255, Errno::EPERM::Errno],
            [:STATUS_REGISTRY_QUOTA_LIMIT,                                      0xC0000256, Errno::EPERM::Errno],
            [:STATUS_PATH_NOT_COVERED,                                          0xC0000257, Errno::EPERM::Errno],
            [:STATUS_NO_CALLBACK_ACTIVE,                                        0xC0000258, Errno::EPERM::Errno],
            [:STATUS_LICENSE_QUOTA_EXCEEDED,                                    0xC0000259, Errno::EPERM::Errno],
            [:STATUS_PWD_TOO_SHORT,                                             0xC000025A, Errno::EPERM::Errno],
            [:STATUS_PWD_TOO_RECENT,                                            0xC000025B, Errno::EPERM::Errno],
            [:STATUS_PWD_HISTORY_CONFLICT,                                      0xC000025C, Errno::EPERM::Errno],
            [:STATUS_PLUGPLAY_NO_DEVICE,                                        0xC000025E, Errno::EPERM::Errno],
            [:STATUS_UNSUPPORTED_COMPRESSION,                                   0xC000025F, Errno::EPERM::Errno],
            [:STATUS_INVALID_HW_PROFILE,                                        0xC0000260, Errno::EPERM::Errno],
            [:STATUS_INVALID_PLUGPLAY_DEVICE_PATH,                              0xC0000261, Errno::EPERM::Errno],
            [:STATUS_DRIVER_ORDINAL_NOT_FOUND,                                  0xC0000262, Errno::EPERM::Errno],
            [:STATUS_DRIVER_ENTRYPOINT_NOT_FOUND,                               0xC0000263, Errno::EPERM::Errno],
            [:STATUS_RESOURCE_NOT_OWNED,                                        0xC0000264, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_LINKS,                                            0xC0000265, Errno::EPERM::Errno],
            [:STATUS_QUOTA_LIST_INCONSISTENT,                                   0xC0000266, Errno::EPERM::Errno],
            [:STATUS_FILE_IS_OFFLINE,                                           0xC0000267, Errno::EPERM::Errno],
            [:STATUS_EVALUATION_EXPIRATION,                                     0xC0000268, Errno::EPERM::Errno],
            [:STATUS_ILLEGAL_DLL_RELOCATION,                                    0xC0000269, Errno::EPERM::Errno],
            [:STATUS_LICENSE_VIOLATION,                                         0xC000026A, Errno::EPERM::Errno],
            [:STATUS_DLL_INIT_FAILED_LOGOFF,                                    0xC000026B, Errno::EPERM::Errno],
            [:STATUS_DRIVER_UNABLE_TO_LOAD,                                     0xC000026C, Errno::EPERM::Errno],
            [:STATUS_DFS_UNAVAILABLE,                                           0xC000026D, Errno::EPERM::Errno],
            [:STATUS_VOLUME_DISMOUNTED,                                         0xC000026E, Errno::EPERM::Errno],
            [:STATUS_WX86_INTERNAL_ERROR,                                       0xC000026F, Errno::EPERM::Errno],
            [:STATUS_WX86_FLOAT_STACK_CHECK,                                    0xC0000270, Errno::EPERM::Errno],
            [:STATUS_VALIDATE_CONTINUE,                                         0xC0000271, Errno::EPERM::Errno],
            [:STATUS_NO_MATCH,                                                  0xC0000272, Errno::EPERM::Errno],
            [:STATUS_NO_MORE_MATCHES,                                           0xC0000273, Errno::EPERM::Errno],
            [:STATUS_NOT_A_REPARSE_POINT,                                       0xC0000275, Errno::EPERM::Errno],
            [:STATUS_IO_REPARSE_TAG_INVALID,                                    0xC0000276, Errno::EPERM::Errno],
            [:STATUS_IO_REPARSE_TAG_MISMATCH,                                   0xC0000277, Errno::EPERM::Errno],
            [:STATUS_IO_REPARSE_DATA_INVALID,                                   0xC0000278, Errno::EPERM::Errno],
            [:STATUS_IO_REPARSE_TAG_NOT_HANDLED,                                0xC0000279, Errno::EPERM::Errno],
            [:STATUS_REPARSE_POINT_NOT_RESOLVED,                                0xC0000280, Errno::EPERM::Errno],
            [:STATUS_DIRECTORY_IS_A_REPARSE_POINT,                              0xC0000281, Errno::EPERM::Errno],
            [:STATUS_RANGE_LIST_CONFLICT,                                       0xC0000282, Errno::EPERM::Errno],
            [:STATUS_SOURCE_ELEMENT_EMPTY,                                      0xC0000283, Errno::EPERM::Errno],
            [:STATUS_DESTINATION_ELEMENT_FULL,                                  0xC0000284, Errno::EPERM::Errno],
            [:STATUS_ILLEGAL_ELEMENT_ADDRESS,                                   0xC0000285, Errno::EPERM::Errno],
            [:STATUS_MAGAZINE_NOT_PRESENT,                                      0xC0000286, Errno::EPERM::Errno],
            [:STATUS_REINITIALIZATION_NEEDED,                                   0xC0000287, Errno::EPERM::Errno],
            [:STATUS_DEVICE_REQUIRES_CLEANING,                                  0x80000288, Errno::EPERM::Errno],
            [:STATUS_DEVICE_DOOR_OPEN,                                          0x80000289, Errno::EPERM::Errno],
            [:STATUS_ENCRYPTION_FAILED,                                         0xC000028A, Errno::EPERM::Errno],
            [:STATUS_DECRYPTION_FAILED,                                         0xC000028B, Errno::EPERM::Errno],
            [:STATUS_RANGE_NOT_FOUND,                                           0xC000028C, Errno::EPERM::Errno],
            [:STATUS_NO_RECOVERY_POLICY,                                        0xC000028D, Errno::EPERM::Errno],
            [:STATUS_NO_EFS,                                                    0xC000028E, Errno::EPERM::Errno],
            [:STATUS_WRONG_EFS,                                                 0xC000028F, Errno::EPERM::Errno],
            [:STATUS_NO_USER_KEYS,                                              0xC0000290, Errno::EPERM::Errno],
            [:STATUS_FILE_NOT_ENCRYPTED,                                        0xC0000291, Errno::EPERM::Errno],
            [:STATUS_NOT_EXPORT_FORMAT,                                         0xC0000292, Errno::EPERM::Errno],
            [:STATUS_FILE_ENCRYPTED,                                            0xC0000293, Errno::EPERM::Errno],
            [:STATUS_WAKE_SYSTEM,                                               0x40000294, Errno::EPERM::Errno],
            [:STATUS_WMI_GUID_NOT_FOUND,                                        0xC0000295, Errno::EPERM::Errno],
            [:STATUS_WMI_INSTANCE_NOT_FOUND,                                    0xC0000296, Errno::EPERM::Errno],
            [:STATUS_WMI_ITEMID_NOT_FOUND,                                      0xC0000297, Errno::EPERM::Errno],
            [:STATUS_WMI_TRY_AGAIN,                                             0xC0000298, Errno::EPERM::Errno],
            [:STATUS_SHARED_POLICY,                                             0xC0000299, Errno::EPERM::Errno],
            [:STATUS_POLICY_OBJECT_NOT_FOUND,                                   0xC000029A, Errno::EPERM::Errno],
            [:STATUS_POLICY_ONLY_IN_DS,                                         0xC000029B, Errno::EPERM::Errno],
            [:STATUS_VOLUME_NOT_UPGRADED,                                       0xC000029C, Errno::EPERM::Errno],
            [:STATUS_REMOTE_STORAGE_NOT_ACTIVE,                                 0xC000029D, Errno::EPERM::Errno],
            [:STATUS_REMOTE_STORAGE_MEDIA_ERROR,                                0xC000029E, Errno::EPERM::Errno],
            [:STATUS_NO_TRACKING_SERVICE,                                       0xC000029F, Errno::EPERM::Errno],
            [:STATUS_SERVER_SID_MISMATCH,                                       0xC00002A0, Errno::EPERM::Errno],
            [:STATUS_DS_NO_ATTRIBUTE_OR_VALUE,                                  0xC00002A1, Errno::EPERM::Errno],
            [:STATUS_DS_INVALID_ATTRIBUTE_SYNTAX,                               0xC00002A2, Errno::EPERM::Errno],
            [:STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED,                               0xC00002A3, Errno::EPERM::Errno],
            [:STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS,                              0xC00002A4, Errno::EPERM::Errno],
            [:STATUS_DS_BUSY,                                                   0xC00002A5, Errno::EPERM::Errno],
            [:STATUS_DS_UNAVAILABLE,                                            0xC00002A6, Errno::EPERM::Errno],
            [:STATUS_DS_NO_RIDS_ALLOCATED,                                      0xC00002A7, Errno::EPERM::Errno],
            [:STATUS_DS_NO_MORE_RIDS,                                           0xC00002A8, Errno::EPERM::Errno],
            [:STATUS_DS_INCORRECT_ROLE_OWNER,                                   0xC00002A9, Errno::EPERM::Errno],
            [:STATUS_DS_RIDMGR_INIT_ERROR,                                      0xC00002AA, Errno::EPERM::Errno],
            [:STATUS_DS_OBJ_CLASS_VIOLATION,                                    0xC00002AB, Errno::EPERM::Errno],
            [:STATUS_DS_CANT_ON_NON_LEAF,                                       0xC00002AC, Errno::EPERM::Errno],
            [:STATUS_DS_CANT_ON_RDN,                                            0xC00002AD, Errno::EPERM::Errno],
            [:STATUS_DS_CANT_MOD_OBJ_CLASS,                                     0xC00002AE, Errno::EPERM::Errno],
            [:STATUS_DS_CROSS_DOM_MOVE_FAILED,                                  0xC00002AF, Errno::EPERM::Errno],
            [:STATUS_DS_GC_NOT_AVAILABLE,                                       0xC00002B0, Errno::EPERM::Errno],
            [:STATUS_DIRECTORY_SERVICE_REQUIRED,                                0xC00002B1, Errno::EPERM::Errno],
            [:STATUS_REPARSE_ATTRIBUTE_CONFLICT,                                0xC00002B2, Errno::EPERM::Errno],
            [:STATUS_CANT_ENABLE_DENY_ONLY,                                     0xC00002B3, Errno::EPERM::Errno],
            [:STATUS_FLOAT_MULTIPLE_FAULTS,                                     0xC00002B4, Errno::EPERM::Errno],
            [:STATUS_FLOAT_MULTIPLE_TRAPS,                                      0xC00002B5, Errno::EPERM::Errno],
            [:STATUS_DEVICE_REMOVED,                                            0xC00002B6, Errno::EPERM::Errno],
            [:STATUS_JOURNAL_DELETE_IN_PROGRESS,                                0xC00002B7, Errno::EPERM::Errno],
            [:STATUS_JOURNAL_NOT_ACTIVE,                                        0xC00002B8, Errno::EPERM::Errno],
            [:STATUS_NOINTERFACE,                                               0xC00002B9, Errno::EPERM::Errno],
            [:STATUS_DS_ADMIN_LIMIT_EXCEEDED,                                   0xC00002C1, Errno::EPERM::Errno],
            [:STATUS_DRIVER_FAILED_SLEEP,                                       0xC00002C2, Errno::EPERM::Errno],
            [:STATUS_MUTUAL_AUTHENTICATION_FAILED,                              0xC00002C3, Errno::EPERM::Errno],
            [:STATUS_CORRUPT_SYSTEM_FILE,                                       0xC00002C4, Errno::EPERM::Errno],
            [:STATUS_DATATYPE_MISALIGNMENT_ERROR,                               0xC00002C5, Errno::EPERM::Errno],
            [:STATUS_WMI_READ_ONLY,                                             0xC00002C6, Errno::EPERM::Errno],
            [:STATUS_WMI_SET_FAILURE,                                           0xC00002C7, Errno::EPERM::Errno],
            [:STATUS_COMMITMENT_MINIMUM,                                        0xC00002C8, Errno::EPERM::Errno],
            [:STATUS_REG_NAT_CONSUMPTION,                                       0xC00002C9, Errno::EPERM::Errno],
            [:STATUS_TRANSPORT_FULL,                                            0xC00002CA, Errno::EPERM::Errno],
            [:STATUS_DS_SAM_INIT_FAILURE,                                       0xC00002CB, Errno::EPERM::Errno],
            [:STATUS_ONLY_IF_CONNECTED,                                         0xC00002CC, Errno::EPERM::Errno],
            [:STATUS_DS_SENSITIVE_GROUP_VIOLATION,                              0xC00002CD, Errno::EPERM::Errno],
            [:STATUS_PNP_RESTART_ENUMERATION,                                   0xC00002CE, Errno::EPERM::Errno],
            [:STATUS_JOURNAL_ENTRY_DELETED,                                     0xC00002CF, Errno::EPERM::Errno],
            [:STATUS_DS_CANT_MOD_PRIMARYGROUPID,                                0xC00002D0, Errno::EPERM::Errno],
            [:STATUS_SYSTEM_IMAGE_BAD_SIGNATURE,                                0xC00002D1, Errno::EPERM::Errno],
            [:STATUS_PNP_REBOOT_REQUIRED,                                       0xC00002D2, Errno::EPERM::Errno],
            [:STATUS_POWER_STATE_INVALID,                                       0xC00002D3, Errno::EPERM::Errno],
            [:STATUS_DS_INVALID_GROUP_TYPE,                                     0xC00002D4, Errno::EPERM::Errno],
            [:STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN,                     0xC00002D5, Errno::EPERM::Errno],
            [:STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN,                      0xC00002D6, Errno::EPERM::Errno],
            [:STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER,                          0xC00002D7, Errno::EPERM::Errno],
            [:STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER,                      0xC00002D8, Errno::EPERM::Errno],
            [:STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER,                       0xC00002D9, Errno::EPERM::Errno],
            [:STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER,                    0xC00002DA, Errno::EPERM::Errno],
            [:STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER,               0xC00002DB, Errno::EPERM::Errno],
            [:STATUS_DS_HAVE_PRIMARY_MEMBERS,                                   0xC00002DC, Errno::EPERM::Errno],
            [:STATUS_WMI_NOT_SUPPORTED,                                         0xC00002DD, Errno::EPERM::Errno],
            [:STATUS_INSUFFICIENT_POWER,                                        0xC00002DE, Errno::EPERM::Errno],
            [:STATUS_SAM_NEED_BOOTKEY_PASSWORD,                                 0xC00002DF, Errno::EPERM::Errno],
            [:STATUS_SAM_NEED_BOOTKEY_FLOPPY,                                   0xC00002E0, Errno::EPERM::Errno],
            [:STATUS_DS_CANT_START,                                             0xC00002E1, Errno::EPERM::Errno],
            [:STATUS_DS_INIT_FAILURE,                                           0xC00002E2, Errno::EPERM::Errno],
            [:STATUS_SAM_INIT_FAILURE,                                          0xC00002E3, Errno::EPERM::Errno],
            [:STATUS_DS_GC_REQUIRED,                                            0xC00002E4, Errno::EPERM::Errno],
            [:STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY,                             0xC00002E5, Errno::EPERM::Errno],
            [:STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS,                             0xC00002E6, Errno::EPERM::Errno],
            [:STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED,                         0xC00002E7, Errno::EPERM::Errno],
            [:STATUS_MULTIPLE_FAULT_VIOLATION,                                  0xC00002E8, Errno::EPERM::Errno],
            [:STATUS_CURRENT_DOMAIN_NOT_ALLOWED,                                0xC00002E9, Errno::EPERM::Errno],
            [:STATUS_CANNOT_MAKE,                                               0xC00002EA, Errno::EPERM::Errno],
            [:STATUS_SYSTEM_SHUTDOWN,                                           0xC00002EB, Errno::EPERM::Errno],
            [:STATUS_DS_INIT_FAILURE_CONSOLE,                                   0xC00002EC, Errno::EPERM::Errno],
            [:STATUS_DS_SAM_INIT_FAILURE_CONSOLE,                               0xC00002ED, Errno::EPERM::Errno],
            [:STATUS_UNFINISHED_CONTEXT_DELETED,                                0xC00002EE, Errno::EPERM::Errno],
            [:STATUS_NO_TGT_REPLY,                                              0xC00002EF, Errno::EPERM::Errno],
            [:STATUS_OBJECTID_NOT_FOUND,                                        0xC00002F0, Errno::EPERM::Errno],
            [:STATUS_NO_IP_ADDRESSES,                                           0xC00002F1, Errno::EPERM::Errno],
            [:STATUS_WRONG_CREDENTIAL_HANDLE,                                   0xC00002F2, Errno::EPERM::Errno],
            [:STATUS_CRYPTO_SYSTEM_INVALID,                                     0xC00002F3, Errno::EPERM::Errno],
            [:STATUS_MAX_REFERRALS_EXCEEDED,                                    0xC00002F4, Errno::EPERM::Errno],
            [:STATUS_MUST_BE_KDC,                                               0xC00002F5, Errno::EPERM::Errno],
            [:STATUS_STRONG_CRYPTO_NOT_SUPPORTED,                               0xC00002F6, Errno::EPERM::Errno],
            [:STATUS_TOO_MANY_PRINCIPALS,                                       0xC00002F7, Errno::EPERM::Errno],
            [:STATUS_NO_PA_DATA,                                                0xC00002F8, Errno::EPERM::Errno],
            [:STATUS_PKINIT_NAME_MISMATCH,                                      0xC00002F9, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_LOGON_REQUIRED,                                  0xC00002FA, Errno::EPERM::Errno],
            [:STATUS_KDC_INVALID_REQUEST,                                       0xC00002FB, Errno::EPERM::Errno],
            [:STATUS_KDC_UNABLE_TO_REFER,                                       0xC00002FC, Errno::EPERM::Errno],
            [:STATUS_KDC_UNKNOWN_ETYPE,                                         0xC00002FD, Errno::EPERM::Errno],
            [:STATUS_SHUTDOWN_IN_PROGRESS,                                      0xC00002FE, Errno::EPERM::Errno],
            [:STATUS_SERVER_SHUTDOWN_IN_PROGRESS,                               0xC00002FF, Errno::EPERM::Errno],
            [:STATUS_NOT_SUPPORTED_ON_SBS,                                      0xC0000300, Errno::EPERM::Errno],
            [:STATUS_WMI_GUID_DISCONNECTED,                                     0xC0000301, Errno::EPERM::Errno],
            [:STATUS_WMI_ALREADY_DISABLED,                                      0xC0000302, Errno::EPERM::Errno],
            [:STATUS_WMI_ALREADY_ENABLED,                                       0xC0000303, Errno::EPERM::Errno],
            [:STATUS_MFT_TOO_FRAGMENTED,                                        0xC0000304, Errno::EPERM::Errno],
            [:STATUS_COPY_PROTECTION_FAILURE,                                   0xC0000305, Errno::EPERM::Errno],
            [:STATUS_CSS_AUTHENTICATION_FAILURE,                                0xC0000306, Errno::EPERM::Errno],
            [:STATUS_CSS_KEY_NOT_PRESENT,                                       0xC0000307, Errno::EPERM::Errno],
            [:STATUS_CSS_KEY_NOT_ESTABLISHED,                                   0xC0000308, Errno::EPERM::Errno],
            [:STATUS_CSS_SCRAMBLED_SECTOR,                                      0xC0000309, Errno::EPERM::Errno],
            [:STATUS_CSS_REGION_MISMATCH,                                       0xC000030A, Errno::EPERM::Errno],
            [:STATUS_CSS_RESETS_EXHAUSTED,                                      0xC000030B, Errno::EPERM::Errno],
            [:STATUS_PKINIT_FAILURE,                                            0xC0000320, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_SUBSYSTEM_FAILURE,                               0xC0000321, Errno::EPERM::Errno],
            [:STATUS_NO_KERB_KEY,                                               0xC0000322, Errno::EPERM::Errno],
            [:STATUS_HOST_DOWN,                                                 0xC0000350, Errno::EPERM::Errno],
            [:STATUS_UNSUPPORTED_PREAUTH,                                       0xC0000351, Errno::EPERM::Errno],
            [:STATUS_EFS_ALG_BLOB_TOO_BIG,                                      0xC0000352, Errno::EPERM::Errno],
            [:STATUS_PORT_NOT_SET,                                              0xC0000353, Errno::EPERM::Errno],
            [:STATUS_DEBUGGER_INACTIVE,                                         0xC0000354, Errno::EPERM::Errno],
            [:STATUS_DS_VERSION_CHECK_FAILURE,                                  0xC0000355, Errno::EPERM::Errno],
            [:STATUS_AUDITING_DISABLED,                                         0xC0000356, Errno::EPERM::Errno],
            [:STATUS_PRENT4_MACHINE_ACCOUNT,                                    0xC0000357, Errno::EPERM::Errno],
            [:STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER,                          0xC0000358, Errno::EPERM::Errno],
            [:STATUS_INVALID_IMAGE_WIN_32,                                      0xC0000359, Errno::EPERM::Errno],
            [:STATUS_INVALID_IMAGE_WIN_64,                                      0xC000035A, Errno::EPERM::Errno],
            [:STATUS_BAD_BINDINGS,                                              0xC000035B, Errno::EPERM::Errno],
            [:STATUS_NETWORK_SESSION_EXPIRED,                                   0xC000035C, Errno::EPERM::Errno],
            [:STATUS_APPHELP_BLOCK,                                             0xC000035D, Errno::EPERM::Errno],
            [:STATUS_ALL_SIDS_FILTERED,                                         0xC000035E, Errno::EPERM::Errno],
            [:STATUS_NOT_SAFE_MODE_DRIVER,                                      0xC000035F, Errno::EPERM::Errno],
            [:STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT,                         0xC0000361, Errno::EPERM::Errno],
            [:STATUS_ACCESS_DISABLED_BY_POLICY_PATH,                            0xC0000362, Errno::EPERM::Errno],
            [:STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER,                       0xC0000363, Errno::EPERM::Errno],
            [:STATUS_ACCESS_DISABLED_BY_POLICY_OTHER,                           0xC0000364, Errno::EPERM::Errno],
            [:STATUS_FAILED_DRIVER_ENTRY,                                       0xC0000365, Errno::EPERM::Errno],
            [:STATUS_DEVICE_ENUMERATION_ERROR,                                  0xC0000366, Errno::EPERM::Errno],
            [:STATUS_WAIT_FOR_OPLOCK,                                           0x00000367, Errno::EPERM::Errno],
            [:STATUS_MOUNT_POINT_NOT_RESOLVED,                                  0xC0000368, Errno::EPERM::Errno],
            [:STATUS_INVALID_DEVICE_OBJECT_PARAMETER,                           0xC0000369, Errno::EPERM::Errno],
            [:STATUS_MCA_OCCURED,                                               0xC000036A, Errno::EPERM::Errno],
            [:STATUS_DRIVER_BLOCKED_CRITICAL,                                   0xC000036B, Errno::EPERM::Errno],
            [:STATUS_DRIVER_BLOCKED,                                            0xC000036C, Errno::EPERM::Errno],
            [:STATUS_DRIVER_DATABASE_ERROR,                                     0xC000036D, Errno::EPERM::Errno],
            [:STATUS_SYSTEM_HIVE_TOO_LARGE,                                     0xC000036E, Errno::EPERM::Errno],
            [:STATUS_INVALID_IMPORT_OF_NON_DLL,                                 0xC000036F, Errno::EPERM::Errno],
            [:STATUS_DS_SHUTTING_DOWN,                                          0x40000370, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_WRONG_PIN,                                       0xC0000380, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_CARD_BLOCKED,                                    0xC0000381, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED,                          0xC0000382, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_NO_CARD,                                         0xC0000383, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_NO_KEY_CONTAINER,                                0xC0000384, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_NO_CERTIFICATE,                                  0xC0000385, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_NO_KEYSET,                                       0xC0000386, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_IO_ERROR,                                        0xC0000387, Errno::EPERM::Errno],
            [:STATUS_DOWNGRADE_DETECTED,                                        0xC0000388, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_CERT_REVOKED,                                    0xC0000389, Errno::EPERM::Errno],
            [:STATUS_ISSUING_CA_UNTRUSTED,                                      0xC000038A, Errno::EPERM::Errno],
            [:STATUS_REVOCATION_OFFLINE_C,                                      0xC000038B, Errno::EPERM::Errno],
            [:STATUS_PKINIT_CLIENT_FAILURE,                                     0xC000038C, Errno::EPERM::Errno],
            [:STATUS_SMARTCARD_CERT_EXPIRED,                                    0xC000038D, Errno::EPERM::Errno],
            [:STATUS_DRIVER_FAILED_PRIOR_UNLOAD,                                0xC000038E, Errno::EPERM::Errno],
            [:STATUS_WOW_ASSERTION,                                             0xC0009898, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_OPCODE,                                       0xC0140001, Errno::EPERM::Errno],
            [:STATUS_ACPI_STACK_OVERFLOW,                                       0xC0140002, Errno::EPERM::Errno],
            [:STATUS_ACPI_ASSERT_FAILED,                                        0xC0140003, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_INDEX,                                        0xC0140004, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_ARGUMENT,                                     0xC0140005, Errno::EPERM::Errno],
            [:STATUS_ACPI_FATAL,                                                0xC0140006, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_SUPERNAME,                                    0xC0140007, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_ARGTYPE,                                      0xC0140008, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_OBJTYPE,                                      0xC0140009, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_TARGETTYPE,                                   0xC014000A, Errno::EPERM::Errno],
            [:STATUS_ACPI_INCORRECT_ARGUMENT_COUNT,                             0xC014000B, Errno::EPERM::Errno],
            [:STATUS_ACPI_ADDRESS_NOT_MAPPED,                                   0xC014000C, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_EVENTTYPE,                                    0xC014000D, Errno::EPERM::Errno],
            [:STATUS_ACPI_HANDLER_COLLISION,                                    0xC014000E, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_DATA,                                         0xC014000F, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_REGION,                                       0xC0140010, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_ACCESS_SIZE,                                  0xC0140011, Errno::EPERM::Errno],
            [:STATUS_ACPI_ACQUIRE_GLOBAL_LOCK,                                  0xC0140012, Errno::EPERM::Errno],
            [:STATUS_ACPI_ALREADY_INITIALIZED,                                  0xC0140013, Errno::EPERM::Errno],
            [:STATUS_ACPI_NOT_INITIALIZED,                                      0xC0140014, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_MUTEX_LEVEL,                                  0xC0140015, Errno::EPERM::Errno],
            [:STATUS_ACPI_MUTEX_NOT_OWNED,                                      0xC0140016, Errno::EPERM::Errno],
            [:STATUS_ACPI_MUTEX_NOT_OWNER,                                      0xC0140017, Errno::EPERM::Errno],
            [:STATUS_ACPI_RS_ACCESS,                                            0xC0140018, Errno::EPERM::Errno],
            [:STATUS_ACPI_INVALID_TABLE,                                        0xC0140019, Errno::EPERM::Errno],
            [:STATUS_ACPI_REG_HANDLER_FAILED,                                   0xC0140020, Errno::EPERM::Errno],
            [:STATUS_ACPI_POWER_REQUEST_FAILED,                                 0xC0140021, Errno::EPERM::Errno],
            [:STATUS_CTX_WINSTATION_NAME_INVALID,                               0xC00A0001, Errno::EPERM::Errno],
            [:STATUS_CTX_INVALID_PD,                                            0xC00A0002, Errno::EPERM::Errno],
            [:STATUS_CTX_PD_NOT_FOUND,                                          0xC00A0003, Errno::EPERM::Errno],
            [:STATUS_CTX_CDM_CONNECT,                                           0x400A0004, Errno::EPERM::Errno],
            [:STATUS_CTX_CDM_DISCONNECT,                                        0x400A0005, Errno::EPERM::Errno],
            [:STATUS_CTX_CLOSE_PENDING,                                         0xC00A0006, Errno::EPERM::Errno],
            [:STATUS_CTX_NO_OUTBUF,                                             0xC00A0007, Errno::EPERM::Errno],
            [:STATUS_CTX_MODEM_INF_NOT_FOUND,                                   0xC00A0008, Errno::EPERM::Errno],
            [:STATUS_CTX_INVALID_MODEMNAME,                                     0xC00A0009, Errno::EPERM::Errno],
            [:STATUS_CTX_RESPONSE_ERROR,                                        0xC00A000A, Errno::EPERM::Errno],
            [:STATUS_CTX_MODEM_RESPONSE_TIMEOUT,                                0xC00A000B, Errno::EPERM::Errno],
            [:STATUS_CTX_MODEM_RESPONSE_NO_CARRIER,                             0xC00A000C, Errno::EPERM::Errno],
            [:STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE,                            0xC00A000D, Errno::EPERM::Errno],
            [:STATUS_CTX_MODEM_RESPONSE_BUSY,                                   0xC00A000E, Errno::EPERM::Errno],
            [:STATUS_CTX_MODEM_RESPONSE_VOICE,                                  0xC00A000F, Errno::EPERM::Errno],
            [:STATUS_CTX_TD_ERROR,                                              0xC00A0010, Errno::EPERM::Errno],
            [:STATUS_CTX_LICENSE_CLIENT_INVALID,                                0xC00A0012, Errno::EPERM::Errno],
            [:STATUS_CTX_LICENSE_NOT_AVAILABLE,                                 0xC00A0013, Errno::EPERM::Errno],
            [:STATUS_CTX_LICENSE_EXPIRED,                                       0xC00A0014, Errno::EPERM::Errno],
            [:STATUS_CTX_WINSTATION_NOT_FOUND,                                  0xC00A0015, Errno::EPERM::Errno],
            [:STATUS_CTX_WINSTATION_NAME_COLLISION,                             0xC00A0016, Errno::EPERM::Errno],
            [:STATUS_CTX_WINSTATION_BUSY,                                       0xC00A0017, Errno::EPERM::Errno],
            [:STATUS_CTX_BAD_VIDEO_MODE,                                        0xC00A0018, Errno::EPERM::Errno],
            [:STATUS_CTX_GRAPHICS_INVALID,                                      0xC00A0022, Errno::EPERM::Errno],
            [:STATUS_CTX_NOT_CONSOLE,                                           0xC00A0024, Errno::EPERM::Errno],
            [:STATUS_CTX_CLIENT_QUERY_TIMEOUT,                                  0xC00A0026, Errno::EPERM::Errno],
            [:STATUS_CTX_CONSOLE_DISCONNECT,                                    0xC00A0027, Errno::EPERM::Errno],
            [:STATUS_CTX_CONSOLE_CONNECT,                                       0xC00A0028, Errno::EPERM::Errno],
            [:STATUS_CTX_SHADOW_DENIED,                                         0xC00A002A, Errno::EPERM::Errno],
            [:STATUS_CTX_WINSTATION_ACCESS_DENIED,                              0xC00A002B, Errno::EPERM::Errno],
            [:STATUS_CTX_INVALID_WD,                                            0xC00A002E, Errno::EPERM::Errno],
            [:STATUS_CTX_WD_NOT_FOUND,                                          0xC00A002F, Errno::EPERM::Errno],
            [:STATUS_CTX_SHADOW_INVALID,                                        0xC00A0030, Errno::EPERM::Errno],
            [:STATUS_CTX_SHADOW_DISABLED,                                       0xC00A0031, Errno::EPERM::Errno],
            [:STATUS_RDP_PROTOCOL_ERROR,                                        0xC00A0032, Errno::EPERM::Errno],
            [:STATUS_CTX_CLIENT_LICENSE_NOT_SET,                                0xC00A0033, Errno::EPERM::Errno],
            [:STATUS_CTX_CLIENT_LICENSE_IN_USE,                                 0xC00A0034, Errno::EPERM::Errno],
            [:STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE,                           0xC00A0035, Errno::EPERM::Errno],
            [:STATUS_CTX_SHADOW_NOT_RUNNING,                                    0xC00A0036, Errno::EPERM::Errno],
            [:STATUS_PNP_BAD_MPS_TABLE,                                         0xC0040035, Errno::EPERM::Errno],
            [:STATUS_PNP_TRANSLATION_FAILED,                                    0xC0040036, Errno::EPERM::Errno],
            [:STATUS_PNP_IRQ_TRANSLATION_FAILED,                                0xC0040037, Errno::EPERM::Errno],
            [:STATUS_SXS_SECTION_NOT_FOUND,                                     0xC0150001, Errno::EPERM::Errno],
            [:STATUS_SXS_CANT_GEN_ACTCTX,                                       0xC0150002, Errno::EPERM::Errno],
            [:STATUS_SXS_INVALID_ACTCTXDATA_FORMAT,                             0xC0150003, Errno::EPERM::Errno],
            [:STATUS_SXS_ASSEMBLY_NOT_FOUND,                                    0xC0150004, Errno::EPERM::Errno],
            [:STATUS_SXS_MANIFEST_FORMAT_ERROR,                                 0xC0150005, Errno::EPERM::Errno],
            [:STATUS_SXS_MANIFEST_PARSE_ERROR,                                  0xC0150006, Errno::EPERM::Errno],
            [:STATUS_SXS_ACTIVATION_CONTEXT_DISABLED,                           0xC0150007, Errno::EPERM::Errno],
            [:STATUS_SXS_KEY_NOT_FOUND,                                         0xC0150008, Errno::EPERM::Errno],
            [:STATUS_SXS_VERSION_CONFLICT,                                      0xC0150009, Errno::EPERM::Errno],
            [:STATUS_SXS_WRONG_SECTION_TYPE,                                    0xC015000A, Errno::EPERM::Errno],
            [:STATUS_SXS_THREAD_QUERIES_DISABLED,                               0xC015000B, Errno::EPERM::Errno],
            [:STATUS_SXS_ASSEMBLY_MISSING,                                      0xC015000C, Errno::EPERM::Errno],
            [:STATUS_SXS_RELEASE_ACTIVATION_CONTEXT,                            0x4015000D, Errno::EPERM::Errno],
            [:STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET,                           0xC015000E, Errno::EPERM::Errno],
            [:STATUS_SXS_EARLY_DEACTIVATION,                                    0xC015000F, Errno::EPERM::Errno],
            [:STATUS_SXS_INVALID_DEACTIVATION,                                  0xC0150010, Errno::EPERM::Errno],
            [:STATUS_SXS_MULTIPLE_DEACTIVATION,                                 0xC0150011, Errno::EPERM::Errno],
            [:STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY,               0xC0150012, Errno::EPERM::Errno],
            [:STATUS_SXS_PROCESS_TERMINATION_REQUESTED,                         0xC0150013, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_INVALID_NODE,                                      0xC0130001, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_EXISTS,                                       0xC0130002, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_JOIN_IN_PROGRESS,                                  0xC0130003, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_NOT_FOUND,                                    0xC0130004, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND,                              0xC0130005, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NETWORK_EXISTS,                                    0xC0130006, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NETWORK_NOT_FOUND,                                 0xC0130007, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NETINTERFACE_EXISTS,                               0xC0130008, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NETINTERFACE_NOT_FOUND,                            0xC0130009, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_INVALID_REQUEST,                                   0xC013000A, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_INVALID_NETWORK_PROVIDER,                          0xC013000B, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_DOWN,                                         0xC013000C, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_UNREACHABLE,                                  0xC013000D, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_NOT_MEMBER,                                   0xC013000E, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS,                              0xC013000F, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_INVALID_NETWORK,                                   0xC0130010, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NO_NET_ADAPTERS,                                   0xC0130011, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_UP,                                           0xC0130012, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_PAUSED,                                       0xC0130013, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NODE_NOT_PAUSED,                                   0xC0130014, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NO_SECURITY_CONTEXT,                               0xC0130015, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_NETWORK_NOT_INTERNAL,                              0xC0130016, Errno::EPERM::Errno],
            [:STATUS_CLUSTER_POISONED,                                          0xC0130017, Errno::EPERM::Errno],
        ].each do |a, b, c|
            const_set(a, b)
            LOOKUP[b] ||= a
            ERRNO[b] ||= c
        end

        def self.raise(status, bt = caller)
            mesg = LOOKUP[status] || ("unknown status - %08x" % status)
            errno = ERRNO[status] || Errno::EPERM::Errno
            except = SystemCallError.new(mesg.to_s, errno)
            except.set_backtrace(bt)
            Kernel.raise(except)
        end
    end
end
