#!/usr/local/bin/ruby
#vim: set fileencoding:utf-8

=begin
Windows 7 64bit / Athlon 64 2.7GHz / ruby 1.9.2p290 (2011-07-09 revision 32553) [i386-mingw32]

ruby launch only (100 times):   0.951000   0.359000   1.310000 ( 43.754503)
identicon load only (100 times):   0.796000   0.421000   1.217000 ( 54.395111)
identicon generate (1000 times):   1.810000   0.047000   1.857000 (  2.006115)

* identiconライブラリのrequire処理に100ミリ秒掛かる
* Identicon.generateに2ミリ秒掛かる
=end

require "benchmark"

puts "ruby launch only (100 times): %s" % [Benchmark.measure { 100.times { system(<<-__END__) } }]
ruby -e ""
__END__

puts "identicon load only (100 times): %s" % [Benchmark.measure { 100.times { system(<<-__END__) } }]
ruby -r ./identicon -e ""
__END__

require "./identicon"
puts "identicon generate (1000 times): %s" % [Benchmark.measure { 1000.times { Identicon.generate rand(1<<32) } }]
