#!ruby
#vim: set fileencoding:utf-8

raise "require ruby-1.9.3+" unless RUBY_VERSION >= "1.9.3"

require "mkmf"

$CPPFLAGS << " -Wall -D_FILE_OFFSET_BITS=64 -DFUSE_USE_VERSION=26"
$CPPFLAGS << " -I#{File.dirname __FILE__} -I#{File.dirname __FILE__}/../external"
$LDFLAGS << " -L#{File.dirname __FILE__}"

#dir_config "dokan", "external", "."
#dir_config "fuse", "external", "."

def ERR(mesg, exitcode = 1)
    $stderr << <<-__END__ << mesg.gsub(/^(?![\n\s]+$)/, "  ")
#$0: しっぱいしました☆
    __END__

    exit exitcode
end

unless have_header("pthread.h") && have_library("pthread")
    ERR <<-__END__
nazuna が依存する、pthread ライブラリが利用できません。
Microsoft Windows 環境の場合は、http://sources.redhat.com/pthreads-win32/ を利用できます。
    __END__
end

case
when have_header("fuse.h") && have_library("fuse")
when have_header("dokan.h") && have_library("dokan")
else
    unless system "dlltool -k -llibdokan.a -Ddokan.dll -ddokan.def" and
           have_header("dokan.h") && have_library("dokan")
        ERR <<-__END__
利用可能なユーザー空間ファイルシステムライブラリが見つかりませんでした。
nazuna は以下のどちらかのライブラリに依存してます。

* fuse - http://fuse.sourceforge.net/ (FreeBSD 環境向け)
* dokan - http://dokan-dev.net/ (Microsoft Windows 環境向け)

あなたの環境で利用できるほうを、あなたの責任の下でインストールする必要があります。
両方利用できない環境の場合は、ほかの環境に移行するか諦めるといいですよ。
えっ? gnu/linux? 難しくてわかりません!
        __END__
    end
end

create_makefile "nazuna" or exit 1
