#!/usr/local/bin/ruby
#vim: set fileencoding:utf-8

# AUTHOR : dearblue <dearblue@users.sourceforge.jp>
# PROJECTPAGE : http://sourceforge.jp/projects/rutsubo/
# LICENSE : Public Domain
# SUMMARY : 読み込み専用ミラーファイルシステムを実現する、Rubyによるユーザー空間ファイルシステムのサンプルコード
# DESCRIPT : I/O要求処理にクラスインスタンスを用いたサンプルコード

# このサンプルコードの著作者であるdearblueは、このサンプルコードに関するすべての権利と義務を漏れなく放棄することを宣言する。
# (要約: このサンプルコードは Public Domain にするよ)


require "nazuna"
require "ioposrw"


# 定数名から想像してね
ROOTDIR = ARGV[0] || "c:/windows"
MOUNTPOINT = ARGV[1] || "w:/"

# いきなり実行してしまう御仁のための端末への表示
$stderr.puts <<-__END__
#$0 (#$$):
    ROOTDIR: #{ROOTDIR}.
    MOUNTPOINT: #{MOUNTPOINT}.
** Ctrl+C to terminate filesystem **
__END__

# 今回のサンプルコードはsigint受け取るのが簡単な終了手段 (他にもdokanctlでunmountする)
# 実際の利用時にはIntterupt例外を捕捉してその後の処理を行わせることも可能です
Signal.trap(:SIGINT) { exit 0 }


class MyFS < Struct.new(:rootdir)
    include Nazuna::Template

    def initialize(rootdir)
        super
    end

    def open(path, mode, flags)
        File.open(File.join(rootdir, path), "rb:binary")
    rescue SystemCallError
        $!
    end

    def read(file, offset, size)
        file.pread(offset, size)
    rescue SystemCallError
        $!
    end

    def opendir(path)
        Dir.open(File.join(rootdir, path), encoding: "utf-8")
    rescue SystemCallError
        $!
    end

    def readdir(dir, offset)
        dir.each do |name|
            yield(name, File.stat(File.join(dir, name))) rescue nil
        end

        0
    end

    def close(file)
        file.close
        0
    rescue SystemCallError
        $!
    end

    def stat(path)
        File.stat(File.join(rootdir, path))
    rescue SystemCallError
        $!
    end

    def fstat(file)
        File.stat(file)
    rescue SystemCallError
        $!
    end
end


logger = ->(ev, id, *args) do
    if ev == :leave && args[0].kind_of?(String)
        p [ev, id]
    else
        p [ev, id, *args]
    end
end


myfs = MyFS.new(ROOTDIR)

# Nazuna#mount は File#read 等と同様にその後の処理を停止させます。
myfs.mount(MOUNTPOINT, nthread: 1, logger: logger)
