#!ruby
#vim: set fileencoding:utf-8

# こういうものではお決まりの『hello world filesystem』。
#
# This sample code is "hello world filesystem".

require "nazuna"

$stderr.puts <<-EOS
#$0: pid=#$$
    "hello world filesystem" sample code running.
    Press key [Ctrl]+[C] to stop.
EOS

module MyFS
    include Errno
    include Nazuna

    if Nazuna::IMPLEMENT == "nazuna-dokan"
        MOUNTPOINT = "w:/"
    else
        MOUNTPOINT = File.join(ENV["HOME"], "nazuna-test")
    end

    ROOT = Object.new
    class << ROOT
        def stat
            Nazuna::Stat.directory(0, Time.now)
        end
    end

    HELLOTEXT = Object.new
    class << HELLOTEXT
        TEXT = <<-EOS.freeze
Hello, world!
This text is read from Ruby via Filesystem in userspace.
Try write script for only your filesystem!
        EOS

        def stat
            Nazuna::Stat.file(TEXT.size, Time.now)
        end

        def read(off, size)
            TEXT.byteslice(off, size)
        end
    end

    Nazuna.mount(MOUNTPOINT) do |io|
        case io
        when Rstat
            case io.path.downcase
            when "/"
                ROOT.stat
            when "/hello.txt"
                HELLOTEXT.stat
            else
                nil
            end
        when Rfstat
            case io.file
            when ROOT, HELLOTEXT
                io.file.stat
            else
                nil
            end
        when Rclose
            0
        when Ropen
            case io.path.downcase
            when "/"
                ROOT
            when "/hello.txt"
                HELLOTEXT
            else
                nil
            end
        when Rread
            case io.file
            when HELLOTEXT
                io.file.read(io.offset, io.size)
            else
                nil
            end
        when Ropendir
            case io.path.downcase
            when "/"
                ROOT
            else
                nil
            end
        when Rreaddir
            case io.dir
            when ROOT
                io.yield("hello.txt")
                0
            else
                nil
            end
        else
            nil
        end
    end
end
