#ifndef SETTINGSDLG_H
#define SETTINGSDLG_H

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include <QDialog>
#include <QHash>

class QFontComboBox;
class QSpinBox;
class QComboBox;
class Settings;
class QToolButton;
class QCheckBox;
class QLineEdit;
class QAction;
//class QHash;

class SettingsDlg : public QDialog
{
	Q_OBJECT

public:
	SettingsDlg(Settings *, QWidget *parent = 0);
	~SettingsDlg();

public:
	bool	softTab() const;
	bool	lineNumber() const;
	int		tabWidth() const;
	//QString	errorEncoding() const;
	QString	fontFamily() const;
	int		fontSize() const;
	QString	userKeywordFileName() const;
	//QString	fileSystemRootPath() const;

public:
	void	setFontFamily(const QString &);
	void	setFontSize(int);

protected:
	QToolButton	*createColorButton(int);
	void	selectColor(int);

protected slots:
	void	btnSelectColor();
	void	selectColor();
	void	namedColor();
	void	selectUserKeywordFile();
	void	apply();
	void	saveColor();
	void	loadColor();

signals:
	void	apply(SettingsDlg *);

private:
	Settings	*m_settings;
	//QFontComboBox	*m_fontCB;
	//QComboBox	*m_errorEncodingCombo;
	QComboBox	*m_fontCombo;
	QSpinBox	*m_fontSpin;
	QSpinBox	*m_tabWidthSpin;
	QCheckBox	*m_softTabCheck;
	QCheckBox	*m_lineNumberCheck;
	QLineEdit	*m_keywordFileEdit;
	//QLineEdit	*m_fileSystemRootPathEdit;
	QHash<int, QToolButton *>	m_ixToButtonHash;

	//QAction		*m_namedColorAct;
};

#endif // SETTINGSDLG_H
