#ifndef EDITVIEW_H
#define EDITVIEW_H

//----------------------------------------------------------------------
//
//			File:			"EditView.cpp"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	EditView NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/


//#include <QTextEdit>
//#include <QPlainTextEdit>
#include "EditViewBase.h"

class RubySyntaxHighliter;
struct Settings;

class EditView : public EditViewBase	//QTextEdit
{
	Q_OBJECT

public:
	EditView(Settings *, QWidget *parent = 0);
	~EditView();

public:
	bool	isRunning() const { return m_running; }
	bool	modifiedAfterCompile() const { return m_modifiedAfterCompile; }
	bool	isSyntaxErrorLine(int) const;

public:
	void	setRunning(bool b) { m_running = b; }
	void	setModifiedAfterCompile(bool b) { m_modifiedAfterCompile = b; }
	void	setSyntaxErrorLineNums(const QList<int> &);
	void	setRegexpFormat(QTextCharFormat *p) { m_regexpFormat = p; }
	void	setQuoteFormat(QTextCharFormat *p) { m_quoteFormat = p; }
	void	onSettingsChanged();
	void	jumpToErrorLine();

public slots:
	void	onContentsChanged();
	void	onModificationChanged ( bool changed );

protected:
	void	drawLeftMargin();
	bool	atJustBehindRegexp(QTextCursor);
	bool	revAutoIndent(const QString &);

protected:
	void	keyPressEvent ( QKeyEvent * e );

private:
    QTextCharFormat	*m_regexpFormat;
    QTextCharFormat	*m_quoteFormat;
	bool	m_running;
	bool	m_modifiedAfterCompile;		//	s or @`FbNɕҏWꂽ
	int		m_errorLineNum;
	int		m_revAIPosition;			//	tCfgʒuiend Ȃǂ̒j
	RubySyntaxHighliter	*m_rubySyntaxHighliter;
	QHash<int, bool>	m_syntaxErrorHashMap;
};

#endif // EDITVIEW_H
