#ifndef RUBYPROCESS_H
#define RUBYPROCESS_H

//----------------------------------------------------------------------
//
//			File:			"mainwindow.cpp"
//			Created:		21-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	RubyProcess NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include <QProcess>
#include <stdio.h>
#ifdef	Q_OS_WIN32
#include <io.h>
#else
#include <unistd.h>
#endif


class RubyProcess : public QProcess
{
	Q_OBJECT

public:
	RubyProcess(QObject *parent = 0);
	~RubyProcess();

public slots:
	void	startRuby(const QStringList &);
	void	writeToRuby(const QString &);

protected:
	void setupChildProcess()
    {
#ifdef	Q_OS_WIN32
        ::_dup2(stdinClone, fileno(stdin));
#else
        ::dup2(stdinClone, fileno(stdin));
#endif
    }

signals:
	void	finished();

private:
	static int stdinClone;
};

#endif // RUBYPROCESS_H
