#ifndef RUBYSYNTAXHIGHLITER_H
#define RUBYSYNTAXHIGHLITER_H

//----------------------------------------------------------------------
//
//			File:			"RubySyntaxHighliter.h"
//			Created:		23-Mar-2012
//			Author:			Nobuhide Tsuda
//			Description:	RubySyntaxHighliter NX錾
//
//----------------------------------------------------------------------

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include <QSyntaxHighlighter>

class EditView;
class ViewTokenizer;

class RubySyntaxHighliter : public QSyntaxHighlighter
{
	Q_OBJECT

#if 0
enum StringType
{
	SingleQuote = 0,
	DoubleQuote,
	RegExp,
};
#endif

public:
	RubySyntaxHighliter( EditView * parentt );
	~RubySyntaxHighliter();

public:
	void	updateFormats();	//	ݒ肪ύXꂽɁAtH[}bgXV

protected:
	void	init();
	void	highlightBlock ( const QString & text );
	QString	hereDocumentIdent(const QTextBlock &);
	bool	highlightString(const ViewTokenizer &, int, uchar);
	//bool	dqString(const ViewTokenizer &);
	//bool	sqString(const ViewTokenizer &);

private:
	EditView	*m_view;

    QRegExp m_cmntStartExp;
    QRegExp m_cmntEndExp;
    QRegExp m_backslashOrSharpExp;
    //QRegExp m_hereDocumentExp;

    QStringList	m_keywords;
    QStringList	m_pseudoVars;

    //QTextCharFormat m_textFormat;
    QTextCharFormat m_cmntFormat;
    //QTextCharFormat m_hereDocumentFormat;
    QTextCharFormat m_keywordFormat;
    QTextCharFormat m_pseudoVarFormat;
    QTextCharFormat m_userKeywordFormat;
    QTextCharFormat m_methodFormat;
    QTextCharFormat m_constantFormat;
    QTextCharFormat m_sqStringFormat;
    QTextCharFormat m_dqStringFormat;
    QTextCharFormat m_bqStringFormat;
    QTextCharFormat m_quoteFormat;
    QTextCharFormat m_escCharFormat;
    QTextCharFormat m_decimalFormat;
    QTextCharFormat m_instanceVarFormat;
    QTextCharFormat m_classVarFormat;
    QTextCharFormat m_globalVarFormat;
    QTextCharFormat m_symbolFormat;
    QTextCharFormat m_regexpFormat;
};

#endif // RUBYSYNTAXHIGHLITER_H
