/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/
#include <QtGui>
#include "SettingsDlg.h"
#include "Settings.h"
#include "NamedColorDlg.h"

SettingsDlg::SettingsDlg(Settings *settings, QWidget *parent)
	: QDialog(parent), m_settings(settings)
{
	setWindowTitle(tr("Settings"));
	QVBoxLayout *vLayout = new QVBoxLayout();
	setLayout(vLayout);
	{
		QHBoxLayout *hLayout = new QHBoxLayout();
		vLayout->addLayout(hLayout);
		hLayout->addWidget(new QLabel(tr("tabWidth:")));
		hLayout->addWidget(m_tabWidthSpin = new QSpinBox());
		m_tabWidthSpin->setRange(2, 16);
		m_tabWidthSpin->setValue(m_settings->m_tabWidth);
		hLayout->addWidget(m_softTabCheck = new QCheckBox(tr("SoftTab")));
		m_softTabCheck->setChecked(m_settings->m_softTab);
#if 0
		hLayout->addSpacing(1);
		hLayout->addWidget(new QLabel(tr("FileSystemRoot:")));
		hLayout->addWidget(m_fileSystemRootPathEdit = new QLineEdit());
		m_fileSystemRootPathEdit->setText(m_settings->m_fileSystemRootPath);
#endif
#if 0
		//	G[o͕GR[fBOI
		hLayout->addSpacing(1);
		hLayout->addWidget(new QLabel(tr("errOutputEncoding:")));
		hLayout->addWidget(m_errorEncodingCombo = new QComboBox);
		m_errorEncodingCombo->setEditable(true);
		m_errorEncodingCombo->addItem("UTF-8");
		m_errorEncodingCombo->addItem("UTF-16LE");
		m_errorEncodingCombo->addItem("UTF-16BE");
		m_errorEncodingCombo->addItem("Shift-JIS");
		m_errorEncodingCombo->addItem("EUC-JP");
		//m_errorEncodingCombo->setText(m_settings->m_errorEncoding);
		int ix = m_errorEncodingCombo->findText(m_settings->m_errorEncoding);
		if( ix < 0 )
			m_errorEncodingCombo->insertItem(ix = 0, m_settings->m_errorEncoding);
		m_errorEncodingCombo->setCurrentIndex(ix);
#endif
		hLayout->addStretch();
		//vLayout->addWidget(m_lineNumberCheck = new QCheckBox(tr("LineNumber")));
		//m_lineNumberCheck->setChecked(m_settings->m_lineNumber);
	}
	{	//	tHgubN
		QGroupBox *box = new QGroupBox(tr("Font Family/Size (point)"));
		vLayout->addWidget(box);
		QHBoxLayout *hLayout = new QHBoxLayout();
		box->setLayout(hLayout);
		//vLayout->addLayout(hLayout);
		hLayout->addWidget(m_fontCombo = new QComboBox);
		QFontDatabase db;
		m_fontCombo->addItems(db.families());
		setFontFamily(m_settings->m_fontFamily);
		hLayout->addWidget(m_fontSpin = new QSpinBox);
		m_fontSpin->setRange(MIN_FONT_SIZE, MAX_FONT_SIZE);
		m_fontSpin->setValue(m_settings->m_fontSize);
		hLayout->addStretch();
	}
	{	//	J[ubN
		QGroupBox *box = new QGroupBox(tr("Color"));
		vLayout->addWidget(box);
		QVBoxLayout *vbLayout = new QVBoxLayout();
		box->setLayout(vbLayout);
		QHBoxLayout *hLayout = new QHBoxLayout();
		vbLayout->addLayout(hLayout);
		//m_namedColorAct = new QAction(tr("NamedColor"), this);
		//connect(m_namedColorAct, SIGNAL(triggered()), this, SLOT(namedColor()));
		//vLayout->addLayout(hLayout);
		{
			QFormLayout *fLayout = new QFormLayout();
			hLayout->addLayout(fLayout);
			fLayout->setLabelAlignment(Qt::AlignRight);
			m_lineNumberCheck = new QCheckBox(tr("LineNumber:"));
			m_lineNumberCheck->setChecked(m_settings->m_lineNumber);
			fLayout->addRow(m_lineNumberCheck, createColorButton(Settings::LINE_NUMBER));
			fLayout->addRow(tr("leftMargin:"), createColorButton(Settings::LEFT_MARGIN));
			fLayout->addRow(tr("errorMark:"), createColorButton(Settings::ERROR_MARK));
			fLayout->addRow(tr("text:"), createColorButton(Settings::TEXT));
			fLayout->addRow(tr("background:"), createColorButton(Settings::BACKGROUND));
			fLayout->addRow(tr("selected text:"), createColorButton(Settings::SEL_TEXT));
			fLayout->addRow(tr("selected BG:"), createColorButton(Settings::SEL_BACKGROUND));
			fLayout->addRow(tr("comment:"), createColorButton(Settings::COMMENT));
		}
		hLayout->addSpacing(1);
		{
			QFormLayout *fLayout = new QFormLayout();
			hLayout->addLayout(fLayout);
			fLayout->setLabelAlignment(Qt::AlignRight);
			fLayout->addRow(tr("keyword:"), createColorButton(Settings::KEYWORD));
			fLayout->addRow(tr("constant:"), createColorButton(Settings::CONSTANT));
			fLayout->addRow(tr("number:"), createColorButton(Settings::DECIMAL));
			fLayout->addRow(tr("instanceVar:"), createColorButton(Settings::INSTANCE_VAR));
			fLayout->addRow(tr("classVar:"), createColorButton(Settings::CLASS_VAR));
			fLayout->addRow(tr("globalVar:"), createColorButton(Settings::GLOBAL_VAR));
			fLayout->addRow(tr("pseudoVar:"), createColorButton(Settings::PSEUDO_VAR));
			fLayout->addRow(tr("symbol:"), createColorButton(Settings::SYMBOL));
		}
		hLayout->addSpacing(1);
		{
			QFormLayout *fLayout = new QFormLayout();
			hLayout->addLayout(fLayout);
			fLayout->setLabelAlignment(Qt::AlignRight);
			fLayout->addRow(tr("method:"), createColorButton(Settings::METHOD));
			fLayout->addRow(tr("Single Quote str:"), createColorButton(Settings::SQ_STRING));
			fLayout->addRow(tr("Double Quote str:"), createColorButton(Settings::DQ_STRING));
			fLayout->addRow(tr("Back Quote str:"), createColorButton(Settings::BQ_STRING));
			fLayout->addRow(tr("quote:"), createColorButton(Settings::QUOTE));
			fLayout->addRow(tr("EscChar:"), createColorButton(Settings::ESC_CHAR));
			//fLayout->addRow(tr("here document:"), createColorButton(Settings::HERE_DOCUMENT));
			fLayout->addRow(tr("regexp:"), createColorButton(Settings::REGEXP));
		}
		hLayout->addStretch();
		{
			QHBoxLayout *hLayout = new QHBoxLayout();
			vbLayout->addLayout(hLayout);
			hLayout->addWidget(new QLabel(tr("userKeyword:")));
			hLayout->addWidget(createColorButton(Settings::USER_KEYWORD));
			hLayout->addWidget(m_keywordFileEdit = new QLineEdit);
			m_keywordFileEdit->setText(m_settings->m_userKeywordFileName);
			QPushButton *ref = new QPushButton(tr("Ref..."));
			hLayout->addWidget(ref);
			connect(ref, SIGNAL(clicked()), this, SLOT(selectUserKeywordFile()));
		}

	}
	vLayout->addStretch(1);
	{	//	OK {^ubN
		QHBoxLayout *hLayout = new QHBoxLayout();
		vLayout->addLayout(hLayout);
		hLayout->addStretch(1);
		QPushButton *saveColorButton = new QPushButton(tr("SaveColor..."));
		connect(saveColorButton, SIGNAL(clicked()), this, SLOT(saveColor()));
		hLayout->addWidget(saveColorButton);
		QPushButton *loadColorButton = new QPushButton(tr("LoadColor..."));
		connect(loadColorButton, SIGNAL(clicked()), this, SLOT(loadColor()));
		hLayout->addWidget(loadColorButton);
		QPushButton *okButton = new QPushButton(tr("OK"));
		okButton->setDefault(true);
		connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));
		hLayout->addWidget(okButton);
		QPushButton *applyButton = new QPushButton(tr("Apply"));
		connect(applyButton, SIGNAL(clicked()), this, SLOT(apply()));
		hLayout->addWidget(applyButton);
#if 0
		QPushButton *cancelButton = new QPushButton(tr("cancel"));
		hLayout->addWidget(cancelButton);
#endif
	}
	Qt::WindowFlags	flags = windowFlags();
	setWindowFlags( flags & ~Qt::WindowContextHelpButtonHint);		//	? {^폜
}

SettingsDlg::~SettingsDlg()
{
}
void SettingsDlg::selectUserKeywordFile()
{
	QString fullPath = QFileDialog::getOpenFileName(this, tr("Select User Keyword File"), "" /*curDir()*/,
													tr("txt Files(*.txt);;All Files(*.*)"));
	if( fullPath.isEmpty() ) return;
	m_keywordFileEdit->setText(fullPath);
}
void SettingsDlg::apply()
{
	emit apply(this);
}
void SettingsDlg::saveColor()
{
	QString fullPath = QFileDialog::getSaveFileName(this, tr("Save Color Settings"), "",
													tr("text files(*.txt);;All Files(*.*)"));
	if( !fullPath.isEmpty() )
		m_settings->saveColor(fullPath);
}
void setButtonColor(QToolButton *btn, const QColor &col)
{
	QPixmap pixmap(48, 48);
	pixmap.fill(col);
	btn->setIcon(QIcon(pixmap));
}
void SettingsDlg::loadColor()
{
	QString fullPath = QFileDialog::getOpenFileName(this, tr("Load Color Settings"),
													"",
													tr("text Files(*.txt);;All Files(*.*)"));
	if( !fullPath.isEmpty()
		&& m_settings->loadColor(fullPath) )
	{
		for(int ix = 0; ix < Settings::N_COLOR; ++ix) {
			QToolButton *btn = m_ixToButtonHash.value(ix);
			setButtonColor(btn, m_settings->color(ix));
		}
		apply();
	}
}
QToolButton	*SettingsDlg::createColorButton(int colorIX)
{
	QToolButton *btn = new QToolButton();
	m_ixToButtonHash.insert(colorIX, btn);
	btn->setPopupMode(QToolButton::MenuButtonPopup);	//	v_Ej[L
	connect(btn, SIGNAL(clicked()), this, SLOT(btnSelectColor()));
	QMenu *menu = new QMenu();
	QAction *btnSelectColorAct = new QAction(this);
	btnSelectColorAct->setData(colorIX);
	btnSelectColorAct->setIcon(btn->icon());
	btn->setDefaultAction(btnSelectColorAct);
	QAction *selectColorAct = new QAction(tr("SelectColor"), this);
	selectColorAct->setData(colorIX);
	menu->addAction(selectColorAct);
	connect(selectColorAct, SIGNAL(triggered()), this, SLOT(selectColor()));
	QAction *namedColorAct = new QAction(tr("NamedColor"), this);
	namedColorAct->setData(colorIX);
	connect(namedColorAct, SIGNAL(triggered()), this, SLOT(namedColor()));
	menu->addAction(namedColorAct);
	btn->setMenu(menu);
	setButtonColor(btn, m_settings->color(colorIX));
	return btn;
}
void SettingsDlg::btnSelectColor()
{
	QToolButton *btn = qobject_cast<QToolButton *>(sender());
	int colorIX = btn->defaultAction()->data().toInt();
	selectColor(colorIX);
}
void SettingsDlg::selectColor()
{
	QAction *act = qobject_cast<QAction *>(sender());
	int colorIX = act->data().toInt();
	selectColor(colorIX);
}
void SettingsDlg::selectColor(int colorIX)
{
	QColorDialog aDlg;
	aDlg.setCurrentColor(m_settings->color(colorIX));
	if( QDialog::Accepted == aDlg.exec() ) {
		QColor col = aDlg.currentColor();
		QToolButton *btn = m_ixToButtonHash.value(colorIX);
		setButtonColor(btn, col);
		m_settings->setColor(colorIX, col);
	}
}
void SettingsDlg::namedColor()
{
	QAction *act = qobject_cast<QAction *>(sender());
	int colorIX = act->data().toInt();
	NamedColorDlg aDlg;
	if( QDialog::Accepted == aDlg.exec() ) {
		//QString colorName = aDlg.colorName();
		QToolButton *btn = m_ixToButtonHash.value(colorIX);
		QColor col(aDlg.colorName());
		setButtonColor(btn, col);
		m_settings->setColor(colorIX, col);
	}
#if 0
	QColorDialog aDlg;
	aDlg.setCurrentColor(m_settings->color(colorIX));
	if( QDialog::Accepted == aDlg.exec() ) {
		QColor col = aDlg.currentColor();
		QPixmap pixmap(48, 48);
		pixmap.fill(col);
		//btn->setIcon(QIcon(pixmap));
		m_settings->setColor(colorIX, col);
	}
#endif
}
bool SettingsDlg::lineNumber() const
{
	return m_lineNumberCheck->isChecked();
}
bool SettingsDlg::softTab() const
{
	return m_softTabCheck->isChecked();
}
int SettingsDlg::tabWidth() const
{
	return m_tabWidthSpin->value();
}
#if 0
QString SettingsDlg::errorEncoding() const
{
	return m_errorEncodingCombo->currentText();
}
#endif
QString SettingsDlg::fontFamily() const
{
	return m_fontCombo->currentText();
}
int SettingsDlg::fontSize() const
{
	return m_fontSpin->value();
}
QString SettingsDlg::userKeywordFileName() const
{
	return m_keywordFileEdit->text();
}
#if 0
QString SettingsDlg::fileSystemRootPath() const
{
	return m_fileSystemRootPathEdit->text();
}
#endif
void SettingsDlg::setFontFamily(const QString &name)
{
	int ix = m_fontCombo->findText(name);
	if( ix >= 0 )
		m_fontCombo->setCurrentIndex(ix);
}
void SettingsDlg::setFontSize(int sz)
{
	m_fontSpin->setValue(sz);
}
