/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/
#include <QtGui>
#include "EditView.h"
#include "ReplaceDlg.h"
#include "Settings.h"

ReplaceDlg::ReplaceDlg(EditView *view, Settings *settings, QWidget *parent)
	: QDialog(parent)
    //, m_settings(settings)	//	̂ gcc Ōxo
	//, m_view(view)
{
    m_settings = settings;
    m_view = view;
	//setWindowFlags(windowFlags() | Qt::Popup );
	setWindowTitle(tr("Find/Replace"));
    //QWidget *w;
	QPushButton *btn;
	QHBoxLayout *hLayout = new QHBoxLayout;
	setLayout(hLayout);
	{
		QVBoxLayout *vLayout = new QVBoxLayout;
		hLayout->addLayout(vLayout);
		QFormLayout *fLayout = new QFormLayout;
		vLayout->addLayout(fLayout);
		fLayout->addRow(tr("FindString:"), m_findStrCombo = new QComboBox());
		m_findStrCombo->setEditable(true);
		m_findStrCombo->lineEdit()->setCompleter(0);	//	I[gRv[gOFF
		foreach(const QString &text, m_settings->findStringList())
			m_findStrCombo->addItem(text);
		fLayout->addRow(tr("ReplaceTo:"), m_replaceToCombo = new QComboBox());
		foreach(const QString &text, m_settings->replaceStringList())
			m_replaceToCombo->addItem(text);
		m_replaceToCombo->setEditable(true);
		const int len = m_findStrCombo->lineEdit()->text().length();
		m_findStrCombo->lineEdit()->setSelection(0, len);
		QHBoxLayout *hLayout2 = new QHBoxLayout;
		vLayout->addLayout(hLayout2);
		{
			QVBoxLayout *vLayout2 = new QVBoxLayout;
			hLayout2->addLayout(vLayout2);
			{
				QGroupBox *gb = new QGroupBox(tr("CaseSensitivity"));
				vLayout2->addWidget(gb);
				QHBoxLayout *gbl = new QHBoxLayout;
				gb->setLayout(gbl);
				gbl->addWidget(m_ignoreCaseCheck = new QRadioButton(tr("ignoreCase")));
				gbl->addWidget(m_caseSensitiveCheck = new QRadioButton(tr("CaseSensitive")));
				if( m_settings->m_ignoreCase )
					m_ignoreCaseCheck->setChecked(true);
				else
					m_caseSensitiveCheck->setChecked(true);
#if 0
				QHBoxLayout *hLayout3 = new QHBoxLayout;
				vLayout2->addLayout(hLayout3);
				QLabel *label = new QLabel(tr("CaseSensitivit&y:"));
				hLayout3->addWidget(label);
				hLayout3->addWidget(m_ignoreCaseCombo = new QComboBox());
				m_ignoreCaseCombo->addItem(tr("ignoreCase"));
				m_ignoreCaseCombo->addItem(tr("caseSensitive"));
				m_ignoreCaseCombo->setCurrentIndex(m_settings->m_ignoreCase ? 0 : 1);	//	FI͌Œ
				label->setBuddy(m_ignoreCaseCombo);
#endif
			}
			vLayout2->addWidget(m_regexpCheck = new QCheckBox(tr("Reg&Exp")));
			m_regexpCheck->setChecked(m_settings->m_regexp);
			connect(m_regexpCheck, SIGNAL(toggled(bool)), this, SLOT(regexpToggled(bool)));
			vLayout2->addWidget(m_wordSearchCheck = new QCheckBox(tr("&WordSearch")));
			m_wordSearchCheck->setEnabled(!m_settings->m_regexp);
			m_wordSearchCheck->setChecked(m_settings->m_wordSearch);
			{
				QGroupBox *gb = new QGroupBox(tr("Loop Option"));
				vLayout2->addWidget(gb);
				QHBoxLayout *gbl = new QHBoxLayout;
				gb->setLayout(gbl);
				gbl->addWidget(m_noLoop = new QRadioButton(tr("NoLoop(&0)")));
				gbl->addWidget(m_confirmLoop = new QRadioButton(tr("Confirm(&1)")));
				gbl->addWidget(m_loop = new QRadioButton(tr("Loop(&2)")));
				switch( m_settings->m_findLoop ) {
				case Settings::FIND_NO_LOOP:	m_noLoop->setChecked(true);	break;
				case Settings::FIND_CONFIRM_LOOP:	m_confirmLoop->setChecked(true);	break;
				case Settings::FIND_LOOP:	m_loop->setChecked(true);	break;
				}
			}
			{
				QVBoxLayout *vLayout3 = new QVBoxLayout;
				hLayout2->addLayout(vLayout3);
				QGroupBox *gb = new QGroupBox(tr("Replace Scope"));
				vLayout3->addWidget(gb);
				QVBoxLayout *gbl = new QVBoxLayout;
				gb->setLayout(gbl);
				gbl->addWidget(m_wholeDoc = new QRadioButton(tr("&WholeThisDoc")));
				gbl->addWidget(m_selectedRange = new QRadioButton(tr("&SelectedRange")));
				m_wholeDoc->setChecked(true);
				//gb->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
				vLayout3->addStretch();
			}
		}
		vLayout->addStretch();
	}
	{
		QVBoxLayout *vLayout = new QVBoxLayout;
		hLayout->addLayout(vLayout);
		QDialogButtonBox *bb = new QDialogButtonBox(Qt::Vertical);
		vLayout->addWidget(bb);
		btn = bb->addButton(tr("Find&Forward"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(findForward()));
		btn = bb->addButton(tr("Find&Bakward"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(findBackward()));
		btn = bb->addButton(tr("&ReplaceNext"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(replaceNext()));
		btn = bb->addButton(tr("Replace&All"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(replaceAll()));
		btn = bb->addButton(tr("&Undo"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SIGNAL(undo()));
		//connect(btn, SIGNAL(clicked()), m_view, SLOT(undo()));
		btn = bb->addButton(tr("Re&do"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SIGNAL(redo()));
		//connect(btn, SIGNAL(clicked()), m_view, SLOT(redo()));
		btn = bb->addButton(tr("&NextDoc"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SIGNAL(nextDoc()));
		//bb->addButton(QDialogButtonBox::Close);
		btn = bb->addButton(tr("Close(Esc)"), QDialogButtonBox::ActionRole);
		connect(btn, SIGNAL(clicked()), this, SLOT(hide()));
		vLayout->addStretch();
	}
}

ReplaceDlg::~ReplaceDlg()
{

}
#if 0
void ReplaceDlg::hideThis()
{
	setVisible(false);
}
#endif

void ReplaceDlg::regexpToggled(bool checked)
{
	m_wordSearchCheck->setEnabled(!checked);
}

//	Settings ̌IvVXV
void ReplaceDlg::updateFindOptions()
{
	m_settings->m_regexp = m_regexpCheck->isChecked();
	m_settings->m_wordSearch = m_wordSearchCheck->isChecked();
	m_settings->m_ignoreCase = m_ignoreCaseCheck->isChecked();
	//m_settings->m_ignoreCase = m_ignoreCaseCombo->currentIndex() == 0;
	m_settings->m_findLoop = m_noLoop->isChecked() ? Settings::FIND_NO_LOOP :
								m_confirmLoop->isChecked() ? Settings::FIND_CONFIRM_LOOP :
								Settings::FIND_LOOP;
}
void ReplaceDlg::addFindString(const QString &text)
{
	m_settings->addFindString(text);	//	IvVɕۑ
	int ix = m_findStrCombo->findText(text);
	if( ix >= 0 )
		m_findStrCombo->removeItem(ix);
	m_findStrCombo->insertItem(0, text);
	m_findStrCombo->setCurrentIndex(0);
}
bool ReplaceDlg::doFind(bool backward, bool noLoop)
{
	if( m_view == 0 ) return false;
	QString text = m_findStrCombo->currentText();
	if( text.isEmpty() ) return false;
	updateFindOptions();
	addFindString(text);
	bool rc = m_view->doFind(text, backward, noLoop);
#if 0
	show();		//	QMessageBox this_CAO\Ȃ邽߂̑Ώ
	raise();	//	
	setFocus();		//	
#endif
	return rc;
}
bool ReplaceDlg::findForward()
{
	return doFind(false);
}
bool ReplaceDlg::findBackward()
{
	return doFind(true);
}
void ReplaceDlg::replaceNext()
{
	if( m_view == 0 ) return;
	QString text = m_findStrCombo->currentText();
	if( text.isEmpty() ) return;
	updateFindOptions();
	m_settings->addFindString(text);
	QTextCursor cur;
	if( !m_view->isMatch(text) ) {
		if( !findForward() )
			return;
		cur = m_view->textCursor();
	} else {
		cur = m_view->textCursor();
		if( !cur.hasSelection() )
			cur.movePosition(QTextCursor::Right, QTextCursor::KeepAnchor, text.length());
	}
	QString repText = m_replaceToCombo->currentText();
	cur.insertText(repText);
	if( !repText.isEmpty() )
		m_settings->addReplaceString(repText);
	findForward();
}
void ReplaceDlg::replaceAll()
{
	if( m_view == 0 ) return;
	QString text = m_findStrCombo->currentText();
	if( text.isEmpty() ) return;
	updateFindOptions();
	QTextCursor cur = m_view->textCursor();
	int first = cur.anchor();
	int last = cur.position();
	if( cur.hasSelection() && m_selectedRange->isChecked() ) {
		if( first > last ) qSwap(first, last);
		cur.setPosition(first);
	} else {
		cur.movePosition(QTextCursor::Start);
		last = -1;		//	whole the Document
	}
	m_view->setTextCursor(cur);
	if( !m_view->isMatch(text) ) {
		if( !doFind(false, /*noLoop=*/true) )
			return;
	}
	QString repText = m_replaceToCombo->currentText();
	if( !repText.isEmpty() )
		m_settings->addReplaceString(repText);
	cur.beginEditBlock();
	int n = 0;
	for(;;) {
		cur = m_view->textCursor();		//	J[\ړĂ̂ŁAĎ擾
		if( last >= 0 ) {
			if( cur.position() > last )
				break;
			last += repText.length() - cur.selectedText().length();		//	IʒuXV
		}
		cur.insertText(repText);
		++n;
		if( !doFind(false, /*noLoop=*/true) )
			break;
	}
	cur.endEditBlock();
	emit showMessage(tr("%1 replaced.").arg(n));
}
