/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/
#include <QtGui>
#include "FileSystemView.h"
#include <QFileSystemModel>
#include <QFileInfo>

FileSystemView::FileSystemView(QWidget *parent)
	: QTreeView(parent)
{
	//setSelectionBehavior(QAbstractItemView::SelectRows);
}

FileSystemView::~FileSystemView()
{

}
void FileSystemView::openCurrentFile()
{
	QModelIndex mi = currentIndex();
	if( !mi.isValid() ) return;
	QFileSystemModel *mdl = (QFileSystemModel *)model();
	QString path = mdl->filePath(mi);
	QFileInfo fi(path);
	if( fi.isFile() )
		emit openFile(path);
}
void FileSystemView::mouseDoubleClickEvent ( QMouseEvent * event )
{
	QTreeView::mouseDoubleClickEvent(event);
	openCurrentFile();
}
void FileSystemView::keyPressEvent ( QKeyEvent * e )
{
#if 1
	const bool ctrl = (e->modifiers() & Qt::ControlModifier) != 0;
	const bool shift = (e->modifiers() & Qt::ShiftModifier) != 0;
	const bool alt = (e->modifiers() & Qt::AltModifier) != 0;
#endif
	QModelIndex mi = currentIndex();
	if( !mi.isValid() ) return;
	QFileSystemModel *mdl = (QFileSystemModel *)model();
	QString path = mdl->filePath(mi);
	QFileInfo fi(path);
	if( fi.isDir() && (e->key() == Qt::Key_Space || e->key() == Qt::Key_Return) ) {
		QKeyEvent ev(QEvent::KeyPress,
						isExpanded(mi) ? Qt::Key_Left : Qt::Key_Right,
						Qt::NoModifier);
		QTreeView::keyPressEvent(&ev);
		return;
	}
	if( !ctrl ) {
		if( e->key() == Qt::Key_Return ) {
			openCurrentFile();
			return;
		} else if( e->key() == Qt::Key_Backspace ) {
		}
	} else {
		if( e->key() == Qt::Key_K ) {
			QKeyEvent ev(QEvent::KeyPress, Qt::Key_Up, Qt::NoModifier);
			QTreeView::keyPressEvent(&ev);
			return;
		}
		if( e->key() == Qt::Key_J ) {
			QKeyEvent ev(QEvent::KeyPress, Qt::Key_Down, Qt::NoModifier);
			QTreeView::keyPressEvent(&ev);
			return;
		}
		if( e->key() == Qt::Key_H ) {
			QKeyEvent ev(QEvent::KeyPress, Qt::Key_Left, Qt::NoModifier);
			QTreeView::keyPressEvent(&ev);
			return;
		}
		if( e->key() == Qt::Key_L ) {
			QKeyEvent ev(QEvent::KeyPress, Qt::Key_Right, Qt::NoModifier);
			QTreeView::keyPressEvent(&ev);
			return;
		}
	}
	QTreeView::keyPressEvent(e);
}
