#ifndef REPLACEDLG_H
#define REPLACEDLG_H

/*

	Copyright (C) 2012 by Nobuhide Tsuda

	RuviEdit ̃CZX MIT{GPL ȃCZXłB 
	ۏ؁ET|[głAŗpłApAvł\[XR[h𗬗p邱Ƃ\łB 
	i\[XR[h𗬗pꍇAp̒쌠ECZXRuviEdit̂̂܂܂łj 
	M҂́AvO}ɂƂĕsRɂ܂Ȃ̂ɎRRƌGPLnȂ̂ŁA 
	RuviEdit ̃\[XGPLnvWFNgŎgp邱Ƃ֎~܂B 
	GPLvWFNgł͈؂̗p֎~܂ALGPLvWFNgł͓INɂ闬p͋܂B

*/

#include <QDialog>

class EditView;
class Settings;
class QComboBox;
class QCheckBox;
class QRadioButton;

class ReplaceDlg : public QDialog
{
	Q_OBJECT

public:
	ReplaceDlg(EditView *, Settings *, QWidget *parent = 0);
	~ReplaceDlg();

public:
	void	setView(EditView *view) { m_view = view; }

protected:
	void	updateFindOptions();	//	Settings ̌IvVXV
	bool	doFind(bool backward, bool noLoop = false);
	void	addFindString(const QString &);

protected slots:
	bool	findForward();
	bool	findBackward();
	void	replaceNext();
	void	replaceAll();
	void	regexpToggled(bool);
	//void	hideThis();

signals:
	void	undo();
	void	redo();
	void	nextDoc();
	void	showMessage(const QString &);

private:
	EditView	*m_view;
	Settings	*m_settings;
	QComboBox	*m_findStrCombo;
	QComboBox	*m_replaceToCombo;
	QRadioButton	*m_ignoreCaseCheck;
	QRadioButton	*m_caseSensitiveCheck;
	//QComboBox	*m_ignoreCaseCombo;
	QCheckBox	*m_regexpCheck;
	QCheckBox	*m_wordSearchCheck;
	QRadioButton	*m_noLoop;
	QRadioButton	*m_confirmLoop;
	QRadioButton	*m_loop;
	QRadioButton	*m_wholeDoc;
	QRadioButton	*m_selectedRange;
};

#endif // REPLACEDLG_H
