/**
 * 
 */
package saccubus.info;

import java.io.File;
import java.util.Properties;

/**
 * @author Account01
 *
 */
public class UserCommentInfo extends AbstractCommentInfo {
	//_E[hRg͎IɌ肷́H
	private boolean EnableAutoAmountDetection;
	private final static boolean DefEnableAutoAmountDetection = true;
	private final static String PropEnableAutoAmountDetection = "EnableAutoAmountDetection";
	//_E[hRǵH
	private int DownloadingAmount;
	private final static int DefDownloadingAmount = 500;
	private final static String PropDownloadingAmount = "DownloadingAmount";
	//ϊRg𐧌H
	private boolean EnableLimitConvertingAmount;
	private final static boolean DefEnableLimitConvertingAmount = false;
	private final static String PropEnableLimitConvertingAmount = "EnableLimitConvertingAmount";
	//ϊRǵH
	private int ConvertingAmount;
	private final static int DefConvertingAmount = 500;
	private final static String PropConvertingAmount = "ConvertingAmount";

	/**
	 * @param autoRenaming
	 * @param autoRenamingFolder
	 * @param file
	 * @param enableDownloading
	 * @param delAfterConv
	 * @param enableConverting
	 * @param visibleAmount
	 * @param enableAutoAmountDetection
	 * @param downloadingAmount
	 * @param enableLimitConvertingAmount
	 * @param convertingAmount
	 */
	public UserCommentInfo(boolean autoRenaming, File autoRenamingFolder, File file, boolean enableDownloading, boolean delAfterConv, boolean enableConverting, int visibleAmount, boolean enableAutoAmountDetection, int downloadingAmount, boolean enableLimitConvertingAmount, int convertingAmount) {
		super(autoRenaming, autoRenamingFolder, file, enableDownloading, delAfterConv, enableConverting, visibleAmount);
		EnableAutoAmountDetection = enableAutoAmountDetection;
		DownloadingAmount = downloadingAmount;
		EnableLimitConvertingAmount = enableLimitConvertingAmount;
		ConvertingAmount = convertingAmount;
	}

	/**
	 * 
	 */
	public UserCommentInfo() {
		super();
	}

	/* (non-Javadoc)
	 * @see saccubus.info.AbstractSavableInfo#getPropID()
	 */
	@Override
	public String getPropID() {
		return "user_comment";
	}

	/* (non-Javadoc)
	 * @see saccubus.info.AbstractConvertableInfo#loadInfo(java.util.Properties)
	 */
	@Override
	public boolean loadInfo(Properties prop) {
		super.loadInfo(prop);
		String str;
		//_E[hRg͎IɌ肷́H
		str = prop.getProperty(getPropID()+PropEnableAutoAmountDetection);
		if(str != null){
			EnableAutoAmountDetection = Boolean.parseBoolean(str);
		}else{
			EnableAutoAmountDetection = isDefEnableAutoAmountDetection();
		}
		//_E[hRǵH
		str = prop.getProperty(getPropID()+PropDownloadingAmount);
		if(str != null){
			DownloadingAmount = Integer.parseInt(str);
		}else{
			DownloadingAmount = getDefDownloadingAmount();
		}
		//ϊRg𐧌H
		str = prop.getProperty(getPropID()+PropEnableLimitConvertingAmount);
		if(str != null){
			EnableLimitConvertingAmount = Boolean.parseBoolean(str);
		}else{
			EnableLimitConvertingAmount = isDefEnableLimitConvertingAmount();
		}
		//ϊRǵH
		str = prop.getProperty(getPropID()+PropConvertingAmount);
		if(str != null){
			ConvertingAmount = Integer.parseInt(str);
		}else{
			ConvertingAmount = getDefConvertingAmount();
		}

		return true;
	}

	/* (non-Javadoc)
	 * @see saccubus.info.AbstractConvertableInfo#saveInfo(java.util.Properties)
	 */
	@Override
	public boolean saveInfo(Properties prop) {
		super.saveInfo(prop);
		//_E[hRg͎IɌ肷́H
		prop.setProperty(getPropID()+PropEnableAutoAmountDetection, Boolean.toString(EnableAutoAmountDetection));
		//_E[hRǵH
		prop.setProperty(getPropID()+PropDownloadingAmount, Integer.toString(DownloadingAmount));
		//ϊRg𐧌H
		prop.setProperty(getPropID()+PropEnableLimitConvertingAmount, Boolean.toString(EnableLimitConvertingAmount));
		//ϊRǵH
		prop.setProperty(getPropID()+PropConvertingAmount, Integer.toString(ConvertingAmount));
		return true;
	}
	/*
	 * ȉGetter/Setter
	 */

	/**
	 * @return convertingAmount
	 */
	public int getConvertingAmount() {
		return ConvertingAmount;
	}

	/**
	 * @param convertingAmount ݒ肷 convertingAmount
	 */
	public void setConvertingAmount(int convertingAmount) {
		ConvertingAmount = convertingAmount;
	}

	/**
	 * @return downloadingAmount
	 */
	public int getDownloadingAmount() {
		return DownloadingAmount;
	}

	/**
	 * @param downloadingAmount ݒ肷 downloadingAmount
	 */
	public void setDownloadingAmount(int downloadingAmount) {
		DownloadingAmount = downloadingAmount;
	}

	/**
	 * @return enableAutoAmountDetection
	 */
	public boolean isEnableAutoAmountDetection() {
		return EnableAutoAmountDetection;
	}

	/**
	 * @param enableAutoAmountDetection ݒ肷 enableAutoAmountDetection
	 */
	public void setEnableAutoAmountDetection(boolean enableAutoAmountDetection) {
		EnableAutoAmountDetection = enableAutoAmountDetection;
	}

	/**
	 * @return enableLimitConvertingAmount
	 */
	public boolean isEnableLimitConvertingAmount() {
		return EnableLimitConvertingAmount;
	}

	/**
	 * @param enableLimitConvertingAmount ݒ肷 enableLimitConvertingAmount
	 */
	public void setEnableLimitConvertingAmount(boolean enableLimitConvertingAmount) {
		EnableLimitConvertingAmount = enableLimitConvertingAmount;
	}

	/**
	 * @return defConvertingAmount
	 */
	public static int getDefConvertingAmount() {
		return DefConvertingAmount;
	}

	/**
	 * @return defDownloadingAmount
	 */
	public static int getDefDownloadingAmount() {
		return DefDownloadingAmount;
	}

	/**
	 * @return defEnableAutoAmountDetection
	 */
	public static boolean isDefEnableAutoAmountDetection() {
		return DefEnableAutoAmountDetection;
	}

	/**
	 * @return defEnableLimitConvertingAmount
	 */
	public static boolean isDefEnableLimitConvertingAmount() {
		return DefEnableLimitConvertingAmount;
	}
	


}
