/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : MemoryLeak.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/12/27
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <unistd.h>
//#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
//#include "etc.h"
#define _MEMORYLEAK_
#include "MemoryLeak.h"



void *_xmalloc(size_t size, int line, char *file)
{
	void *p;
	ALLOC_ELEMENT *ae;


	/* xmalloc(size) で指定されたサイズのメモリブロックを確保する */
	p = malloc(size);
	if (p == NULL) {
		return NULL;
	}
	
	/* ALLOC_ELEMENT の確保 */
	ae = (ALLOC_ELEMENT *) malloc(sizeof(ALLOC_ELEMENT));
	if (ae == NULL) {
		free(p);
		return NULL;
	}
	
	ae->alloc_ptr = p;
	ae->alloc_line = line;
	ae->alloc_file = GetFileName(file);
//	ae->alloc_file = file;
	
	/* リスト構造に ALLOC_ELEMENT を追加 */
	if (_top == NULL) {
		ae->next = NULL;
		_top = ae;
	}
	else {
		ae->next = _top;
		_top = ae;
	}
	
	return p;
}



void _xfree(void *p, int line, char *file)
{
	ALLOC_ELEMENT *q;
	ALLOC_ELEMENT *r;
	char output_path[MAXPATHLEN];
	char str[256];
	FILE *stream;

	q = r = _top;
	while (q != NULL) {
		if (q->alloc_ptr == p) {
			if (q == _top) {
				_top = q->next;
			}
			else {
				r->next = q->next;
			}
			free(q);
			free(p);
			break;
		}
		r = q;
		q = q->next;
	}
	
	if (q == NULL) {
		MemoryDebugLogPath(output_path);
		/* ファイルをオープン */ 
		if((stream = fopen(output_path, "a")) == NULL) {
			return;
		}
		sprintf(str, "%s(%d) : XFREE : illegal pointer(0x%x)\n", GetFileName(file), line, (int)p);
//		sprintf(str, "XFREE: %s(%d) : illegal pointer(0x%x)\n", file, line, p);
		fputs(str, stream);
		g_print("%s",str);
		/* ファイルをクローズ */ 
		fclose(stream);
	}
}



void _xdump(void)
{
	ALLOC_ELEMENT *p = _top;
	ALLOC_ELEMENT *q;
	int count = 1;
	char output_path[MAXPATHLEN];
	char str[256];
	FILE *stream;


	MemoryDebugLogPath(output_path);
sprintf(output_path, "./MemoryDebugLog");
	/* ファイルをオープン */ 
	if((stream = fopen(output_path, "a")) == NULL) {
		g_print("XDUMP : Not Open MemoryDebugLog [%s]\n", output_path);
		return;
	}


	g_print("XDUMP : Save [%s]\n", output_path);


	if (p == NULL) {
		sprintf(str, "XDUMP : all memory blocks deallcated\n");
		fputs(str, stream);
		g_print("%s",str);
	}
	else {
		sprintf(str, "XDUMP : memory leaks detected [start]\n");
		fputs(str, stream);
		g_print("%s",str);
		while (p != NULL) {
			sprintf(str, "%s(%d) : memory leak(0x%x) : memory leaks [%d]\n", 
				p->alloc_file, 
				p->alloc_line, 
				(int)p->alloc_ptr, 
				count++);
			fputs(str, stream);
			g_print("%s", str);
			q = p->next;
			free(p);
			p = q;
		}
		sprintf(str, "XDUMP : memory leaks detected [end]\n");
		fputs(str, stream);
			g_print("%s",str);
	}

	/* ファイルをクローズ */ 
	fclose(stream);
}





/* -------------------------------------------------------------------
 * メモリデバッグのログのパスを求める。
 * 
 * 
 */
int MemoryDebugLogPath(char *output_path)
{
	char home[MAXPATHLEN];

#ifdef G_OS_WIN32
	sprintf(home, "%s", g_get_home_dir());
#else
	sprintf(home, "%s", g_get_home_dir());
/*
	uid_t uid;
	struct passwd *pwd;

	uid = getuid();
	pwd = getpwuid(uid);
	strcpy (home, pwd->pw_dir);
*/
#endif

	sprintf(output_path, "%s/MemoryDebug", home);
	return 0;
}





/* -------------------------------------------------------------------
 * メモリデバッグのログを消去
 * 
 * アプリケーション開始時に前回のログを消去
 */
int DeleteMemoryDebugLog(void)
{
	char path[MAXPATHLEN];

	MemoryDebugLogPath(path);
	unlink(path);

	return 1;
}





/* -------------------------------------------------------------------
 * フルパス名からファイル名を取得する
 *	
 * char *lpszPath	  ファイル名を含むパス名へのポインタ
 * char * ファイル名へのポインタ
 * ファイル名を含まないときは""へのポインタ
 * [\],[/],[:]が見つからなかった場合、引数をファイル名とみなしてそのまま返す
 *	
 * パス名の先頭から文字列を検索して，「:,\,/」のいずれかが最後に現れる地点を探す。
 * 文字を比較するときは，比較対象の文字が2バイト文字か1バイト文字かを調べる必要があります。
 *	
 * 「"」に囲まれた,は数えない
 */
char *GetFileName(char *lpszPath)
{
	char *lpszPtr = lpszPath;

	while(*lpszPtr != '\0') {
		/* [\],[/],[:]を見つけたら現在地+1のポインタを保存 */
		if((*lpszPtr == '\\') || (*lpszPtr == '/') || (*lpszPtr == ':')) {
			lpszPath=lpszPtr+1;
		}
		/* 次の文字へ */
		lpszPtr++;
	}
	return lpszPath;
}





#ifdef SAMPLE
main()
{
	int i;
	char *p;
	char *q;


	p = xmalloc(16);
	p = xmalloc(16);
	q = p;
	p = xmalloc(16);
	p = xmalloc(16);

	xfree(p+4);
	xfree(q);

	xdump();
}
#endif



/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : MemoryLeak.c
 * ====================================================================
 */
