/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : about.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/22
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#define _ABOUT_
#include "about.h"

#include "xpm/sagcad.xpm"



/* -------------------------------------------------------------------
 * OK "pushed"
 * 
 */
void about_ok_pushed(GtkWidget *widget, gpointer data)
{
	return;
}


/* -------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint about_key_press_event(GtkWidget *widget, GdkEventKey *event, gpointer data)
{
//	g_print("sagcad.c : culcinput_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);

	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		about_ok_pushed(widget, NULL);
		gtk_main_quit();
	}
	return FALSE;
}



/* -------------------------------------------------------------------
 * about SagCAD
 * 
 */
gint about(GtkWidget *parent)
{
	char str[256];


	GtkWidget *dialog;
	GtkWidget *main_vbox;
		GtkWidget *hbox;
			GtkWidget *image;
			GdkPixmap *pixmap;
			GdkBitmap *mask;

			GtkWidget *label_vbox;
				GtkWidget *title_label;
				GtkWidget *version_label;
			GtkWidget *copyright1_label;
			GtkWidget *copyright2_label;
			GtkWidget *copyright3_label;
			GtkWidget *reserved_label;
		GtkWidget *separator;
		GtkWidget *ok_buttun;


	/* ダイアログ(dialog)生成 */
	dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(dialog), "SagCAD");
	gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(parent));
	g_signal_connect( G_OBJECT(dialog), "key_press_event",
				G_CALLBACK(about_key_press_event), NULL);


		/* ダイアログの中にまず、パッキングボックス(main_vbox)を作成 */
		main_vbox = gtk_vbox_new(0, 5);
		gtk_container_add(GTK_CONTAINER(dialog), main_vbox);
		gtk_container_set_border_width(GTK_CONTAINER(dialog), 5);
		gtk_widget_show(main_vbox);

			/* パッキングボックス(hbox) */
			hbox = gtk_hbox_new(FALSE, 10);
			gtk_box_pack_start(GTK_BOX(main_vbox), hbox, TRUE, TRUE, 0);
			gtk_widget_show(hbox);

					/* icon */
					/*
					pixmap = gdk_pixmap_create_from_xpm_d(dialog->window, 
								 &mask, 
								 &dialog->style->bg[GTK_STATE_NORMAL],
								 (gchar **)sagcad_xpm);
					image = gtk_pixmap_new(pixmap, mask);
					gtk_box_pack_start(GTK_BOX(hbox), image, TRUE, TRUE, 0);
					gtk_widget_show(image);
					*/


				/* ダイアログの中にまず、パッキングボックス(main_vbox)を作成 */
				label_vbox = gtk_vbox_new(0, 2);
				gtk_box_pack_start(GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
				gtk_widget_show(label_vbox);

					/* title_label */
					title_label = gtk_label_new("SagCAD");
					gtk_misc_set_alignment(GTK_MISC(title_label), 0.0f, 1.0f);
//					gtk_widget_set_size_request(title_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(title_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), title_label, TRUE, TRUE, 0);
					gtk_widget_show(title_label);

					/* version_label */
					sprintf(str, "Version ");
					strcat(str, VERSION);
					version_label = gtk_label_new(str);
					gtk_misc_set_alignment(GTK_MISC(version_label), 0.0f, 1.0f);
//					gtk_widget_set_size_request(version_label, 300, 20);
					gtk_box_pack_start(GTK_BOX(label_vbox), version_label, TRUE, TRUE, 0);
					gtk_label_set_justify(GTK_LABEL(version_label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(version_label);

					/* copyright1_label */
					copyright1_label = gtk_label_new("Copyright (C) 1998-2007");
					gtk_misc_set_alignment(GTK_MISC(copyright1_label), 0.0f, 1.0f);
//					gtk_widget_set_size_request(copyright1_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(copyright1_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), copyright1_label, TRUE, TRUE, 0);
					gtk_widget_show(copyright1_label);

					/* copyright2_label */
					copyright2_label = gtk_label_new("Yutaka Sagiya.");
					gtk_misc_set_alignment(GTK_MISC(copyright2_label), 0.0f, 1.0f);
//					gtk_widget_set_size_request(copyright2_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(copyright2_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), copyright2_label, TRUE, TRUE, 0);
					gtk_widget_show(copyright2_label);

					/* copyright3_label */
					copyright3_label = gtk_label_new("Sagiya Metal Mold Factory,Inc.");
					gtk_misc_set_alignment(GTK_MISC(copyright3_label), 0.0f, 1.0f);
//					gtk_widget_set_size_request(copyright3_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(copyright3_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), copyright3_label, TRUE, TRUE, 0);
					gtk_widget_show(copyright3_label);

					/* reserved_label */
					reserved_label = gtk_label_new("All Rights Reserved.");
					gtk_misc_set_alignment(GTK_MISC(reserved_label), 0.0f, 1.0f);
//					gtk_widget_set_size_request(reserved_label, 300, 20);
					gtk_label_set_justify(GTK_LABEL(reserved_label), GTK_JUSTIFY_LEFT);
					gtk_box_pack_start(GTK_BOX(label_vbox), reserved_label, TRUE, TRUE, 0);
					gtk_widget_show(reserved_label);


		/* セパレーター(separator) */
		separator = gtk_hseparator_new();
		gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
		gtk_widget_show(separator);


		/* -----------------------------------------------------
		 * パッキングボックス(action_hbox) に入れる
		 * ボタン(cancel_buttun & ok_buttun) を作成し
		 * 格納する
		 */
		/* OKボタンの生成 */
		ok_buttun = gtk_button_new_with_label("OK");
		gtk_widget_set_size_request(ok_buttun, 80, 22);
		gtk_box_pack_start(GTK_BOX(main_vbox), ok_buttun, TRUE, TRUE, 2);
		g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(about_ok_pushed), NULL);
		g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(ok_buttun);

	/*  フォーカスを ok_buttun に設定 */
	gtk_window_set_focus(GTK_WINDOW(dialog), ok_buttun);

	/* ダイアログを可視状態へ */
	gtk_widget_show(dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : about.c
 * ====================================================================
 */
