#pragma once
#include "basic_type.hpp"
#include "utils/file_path.hpp"
#include "reference.hpp"

#include <vector>
#include <boost/shared_ptr.hpp>

class NesMemoryMapper;
class INesFile;


class OriginScanner
{
public:
    static std::vector<Word> scanOrigin(
            const INesFile& cartridge, unsigned threshold);
};

class CodeDataModule
{
public:
    static PByteSequence parse(const NesMemoryMapper& mapper);
    static PByteSequence load(const FilePath& file_name);
    static void edit(
            PByteSequence& cdflags,
            const std::vector<PByteSequence>& banks,
            const std::vector<Word>& origins,
            FilePath file_name);
};

