#pragma once

namespace nes {
enum MemoryAddressMap {
	STACK_OFFSET=0x0100,
	RAM_END = 0x2000,
	IO_REG_OFFSET=RAM_END, IO_REG_END=0x4000,
	IO_REG_OFFSET2=IO_REG_END, IO_REG_END2=0x4020,
	EXPANSION_ROM_OFFSET = IO_REG_END2, EXPANSION_ROM_END = 0x6000,
	SRAM_OFFSET=EXPANSION_ROM_END, SRAM_END = 0x8000,
	CODE_OFFSET=0x8000, CODE_END = 0x010000,
	
	NMI_ADDR=0xFFFA, RESET_ADDR=0xFFFC, IRQ_ADDR=0xFFFE,
	INTERRUPT_ADDR=NMI_ADDR,
	
	RAM_SIZE=0x0800,
	SRAM_SIZE=0x8000-0x6000,
	
	BANK_SIZE =0x2000, /* 8kb */
	
	PRG_PAGE_SIZE =0x4000, /* 16kb used in iNes Header*/
	CHR_PAGE_SIZE =0x2000,
	
	PAGE_NUM=4,
};

}//end of namespace
class NesMemoryMapHelper
{
public:
    static bool isRomAddress(Word addr)
    {
        return nes::CODE_OFFSET <= addr && addr < nes::CODE_END;
    }
    static unsigned pageIndexByAddress(Word addr)
    {
        assert(addr >= nes::CODE_OFFSET);
        assert(addr <= nes::CODE_END);
        return ((addr&0xFFFF)-nes::CODE_OFFSET)/nes::BANK_SIZE;
    }
    /** the index is 0..3 */
    static Word pageOrigin(unsigned page_idx)
    {
        return page_idx*nes::BANK_SIZE+nes::CODE_OFFSET;
    }
};
