#pragma once

#include "basic_type.hpp"

#include <vector>
#include <bitset>
#include <set>
#include <iostream>
#include <map>
#include <boost/shared_ptr.hpp>
#include "graph.hpp"

#include "instruction.hpp"

namespace reference {
enum ReferenceTypeInner {
	REFERENCE_UND=0,
    WRITE, IDX_WRITE, PRE_IND_WRITE, POST_IND_WRITE, 
    READ, IDX_READ, PRE_IND_READ, POST_IND_READ, 
	JUMP, IND_JUMP, JUMP_TABLE,
    CALL, IND_CALL,
    RETURN, STK_JUMP,
    BREAK,
    BRANCH,
	JUNCTION,
    UNCALL, SUSPECIOUS_CALL,
	REFERENCE_NUM,
};
enum Constants {
    ABSOLUTE_REFERER,
};

}//end of namespace
typedef reference::ReferenceTypeInner ReferenceType;



typedef Graph<MemoryID, ReferenceType> ReferenceGraph;


class Reference;
typedef boost::shared_ptr<Reference> PReference;


class ReferenceHelper
{
public:
    static std::string name(ReferenceType type);
    static ReferenceType map(OpcodeType op_type);
    static ReferenceType mapWithAddressingMode(OpcodeType op_type,
                                        AddressingMode mode);
    static bool isDataAccess(ReferenceType type);
    static bool isControlChange(ReferenceType type);
};


class ReferenceSelector
{
public:
    static std::set<MemoryID> select(const ReferenceGraph& graph,
                                     ReferenceType condition);
    static std::set<MemoryID> entries(const ReferenceGraph& graph);
    static std::set<MemoryID> topLevelEntries(
            const ReferenceGraph& graph);
    static std::set<MemoryID> anyLabel(const ReferenceGraph& graph);
    static std::set<MemoryID> codeLabel(const ReferenceGraph& graph);
    static std::set<MemoryID> dataLabel(const ReferenceGraph& graph);
};


class Reference
{
public:
	typedef std::vector<std::bitset<opcode::ADDRESSING_NUM> >
    Statistic;
private:
	const MemoryID m_id;
	const Word m_address; 
	Statistic m_n_times;
public:
	Reference(MemoryID id, Word hard_address)
            :m_id(id),m_address(hard_address)
	{ clear(); }
    
	MemoryID id()const { return m_id; }
	Word address()const { return m_address; }
	const Statistic& statistics()const { return m_n_times; }
    
    bool empty()const
    {
		for (unsigned i=0; i<m_n_times.size(); ++i) {
            if (m_n_times[i].any()) {
                return false;
            }
		}
        return true;
    }
	bool isType(ReferenceType type)const
	{
		return m_n_times[type].any();
	}
	void clear() 
	{
		m_n_times.resize(reference::REFERENCE_NUM);
		for (unsigned i=0; i<m_n_times.size(); ++i) {
			m_n_times[i].reset();
		}
	}
    /** record referer and the type of access.*/
	void refer(ReferenceType type,
               AddressingMode mode) 
	{
		m_n_times[type][mode] = true;
	}
    /** exclude the type from the record.*/
    void exclude(ReferenceType type)
    {
        m_n_times[type].reset();
    }
};

/** convert reference to visible code.*/
class ReferenceCode
{
	Reference::Statistic m_n_times;
public:
	ReferenceCode(const Reference& reference);
	void display(std::ostream& os)const;
private:
	void init(const Reference::Statistic& n_times);
	unsigned variation() const;
};


