#pragma once
#include <iostream>
#include <string>

/** This utility is used to covert number to hexadecimal string.
 * It used to represent Hexadecimal value and string.
 */
class HexadecimalFormat
{
	unsigned long m_value;
	unsigned m_width;
	char m_filling;
	bool m_upper;
	bool m_is_valid;
public:
	/** get invalid value */
	static const HexadecimalFormat invalid();
	/** construct from value.*/
	HexadecimalFormat(unsigned long value=0);
	bool isValid()const;
	/** construct from string.*/
	HexadecimalFormat(std::string line);
	bool isAccept(char c)const;
	/** copy.*/
	HexadecimalFormat(const HexadecimalFormat& that);
	/** downcast in context of unsigned value.*/
	operator unsigned long()const;
	/** assign.*/
	HexadecimalFormat& operator=(const HexadecimalFormat& rh);
	/** assign by value.*/
	HexadecimalFormat& operator=(unsigned long value);
	/** add the value, ignore format.*/
	HexadecimalFormat operator+(const HexadecimalFormat& rh)const;
	/** subtract, ignore format.*/
	HexadecimalFormat operator-(const HexadecimalFormat& rh)const;
	/** add value.*/
	HexadecimalFormat& operator+=(unsigned long value);
	/** subtract value.*/
	HexadecimalFormat& operator-=(unsigned long value);
	/** set format width.*/
	HexadecimalFormat& width(unsigned w);
	/** set format width.*/
	HexadecimalFormat width(unsigned w)const;
	/** 0x00FF <- 0x00ff*/
	HexadecimalFormat& upper(bool is_upper);
	HexadecimalFormat low()const;
	HexadecimalFormat high()const;
	std::string fillings(unsigned n)const;
	std::string to_s()const;
	/** display.*/
	friend std::ostream& operator<<(std::ostream& os,
									const HexadecimalFormat& rh);
	/** read*/
	friend std::istream& operator>>(std::istream& is,
									HexadecimalFormat& rh);
};

class BinaryFormat
{
	unsigned m_value;
	unsigned m_width;
	char m_off;
	char m_on;
	unsigned m_length;
	char m_delimiter;
public:
	BinaryFormat();
	BinaryFormat(unsigned value);
	BinaryFormat(const BinaryFormat& that);
	bool operator [](unsigned index)const;
	operator unsigned();
	BinaryFormat width(unsigned w)const;
	BinaryFormat length(unsigned len)const;
	void display(std::ostream& os)const;
	friend std::ostream& operator<<(std::ostream& os, const BinaryFormat& rh);
};

class DecimalFormat
{
	int m_value;
	unsigned m_width;
	char m_filling;
public:
	DecimalFormat(int value);
	/** construct from string.*/
	DecimalFormat(std::string line);
	DecimalFormat(const DecimalFormat& that);
	operator int();
	DecimalFormat width(unsigned w)const;
	DecimalFormat length(unsigned len)const;
	void display(std::ostream& os)const;
	std::string to_s()const;
	friend std::ostream& operator<<(std::ostream& os, const DecimalFormat& rh);
	
};
