#pragma once
#include "stream_filter.hpp"
namespace chocolat{namespace filter{
/** this filter show head of stream.*/
class head : public IStreamFilter{
public:
	/** if count is negative, it means all */
	head(int i=10):m_count(i){}
	virtual IStreamFilter* clone()const
	{
		return new head(m_count);
	}
	virtual void operator()(std::istream& is, std::ostream& os)
	{
		for (int i=0; i!=m_count && !is.eof(); ++i){
			std::string line;
			getline(is, line);
			os << line;
			if (!is.eof() && i!=m_count-1){
				os << std::endl;
			}
		}
	}
private:
	int m_count;
};
/** this filter show tail of stream. */
class tail : public IStreamFilter{
public:
	virtual IStreamFilter* clone()const
	{
		return new tail();
	}
	virtual void operator()(std::istream& is, std::ostream& os)
	{
		std::vector<std::string> v;
		while (!is.eof()){
			std::string line;
			getline(is, line);
			v.push_back(line);
		}
		unsigned int begin = (v.size() < 5) ? 0 : v.size()-5;
		for (unsigned int i=begin; i<v.size(); ++i){
			os << v[i];
			if (i != v.size() - 1){
				os << std::endl;
			}
		}
	}
};
}}
