package jp.sourceforge.tamanegisoul.sa.action;

import jp.sourceforge.tamanegisoul.sa.R;
import jp.sourceforge.tamanegisoul.sa.util.AppAlarmManager;
import jp.sourceforge.tamanegisoul.sa.util.LogUtil;
import jp.sourceforge.tamanegisoul.sa.util.PreferenceUtils;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Vibrator;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.Toast;

/**
 * アラーム鳴動画面
 */
public class DoAlarmActivity extends Activity {

    private Window mWindow;
    private MediaPlayer mRingtone;
    private Vibrator mVibrator;
    private BroadcastReceiver mReceiver;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        LogUtil.d("DoAlarmActivity called.");
        super.onCreate(savedInstanceState);

        // スクリーンオフ操作された時にアラーム停止orスヌーズするためにReceiverを利用
        mReceiver = new BroadcastReceiver() {
            @Override
            public void onReceive(Context context, Intent intent) {
                LogUtil.d("onReceive()");
                leaveByHardkeyEvent();
            }
        };
        registerReceiver(mReceiver, new IntentFilter(Intent.ACTION_SCREEN_OFF));

        // アラーム用の音量設定を使用
        setVolumeControlStream(AudioManager.STREAM_ALARM);

        // スクリーンロックを解除
        // KeyguardLockとPowerManagerを使う方法はスクリーンロックが解除できなかったので、このやり方で。
        requestWindowFeature(android.view.Window.FEATURE_NO_TITLE);
        mWindow = getWindow();
        mWindow.addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED | WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD);
        mWindow.addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);

        mVibrator = (Vibrator) getSystemService(Context.VIBRATOR_SERVICE);
        mRingtone = new MediaPlayer();

        setContentView(R.layout.do_alarm);

        // ストップボタン
        Button stopButton = (Button) findViewById(R.id.stop_button);
        final String snoozePref = PreferenceUtils.getString(this, "snooze");
        stopButton.setText(snoozePref == null || snoozePref.equals("") ? "長押しで停止" : "スヌーズ\n(長押しで停止)");
        stopButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (snoozePref != null && !snoozePref.equals(""))
                    snooze();
            }
        });
        stopButton.setOnLongClickListener(new View.OnLongClickListener() {
            @Override
            public boolean onLongClick(View v) {
                nextAlarm();
                return true;
            }
        });
        LogUtil.d("DoAlarmActivity created.");
    }

    @Override
    public void onStart() {
        super.onStart();

        // バイブレーター
        long[] vibratorPattern = PreferenceUtils.getVibratorPattern(this);
        if (vibratorPattern != null) {
            mVibrator.vibrate(vibratorPattern, 0);
        }

        // アラーム音
        Uri ringtoneUri = PreferenceUtils.getRingtone(this);
        if (ringtoneUri != null) {
            mRingtone.reset();
            try {
                mRingtone.setDataSource(this, ringtoneUri);
                // ↓これでアラームの音量設定が使われる
                mRingtone.setAudioStreamType(AudioManager.STREAM_ALARM);
                mRingtone.setLooping(true);
                mRingtone.prepare();
                mRingtone.start();
            } catch (Exception e) {
                Toast.makeText(this, "Failed to ring", Toast.LENGTH_LONG).show();
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        unregisterReceiver(mReceiver);
        mVibrator.cancel();
        mRingtone.stop();
        mRingtone.release();
        // スクリーンロックを戻す(これに意味があるかは？)
        mWindow.clearFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED | WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD);
        mWindow.clearFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
    }

    @Override
    protected void onUserLeaveHint() {
        // ホームキー押下で呼ばれる
        leaveByHardkeyEvent();
        super.onUserLeaveHint();
    }

    @Override
    public void onBackPressed() {
        // 戻るボタン押下で呼ばれる
        leaveByHardkeyEvent();
    }

    /**
     * アプリの画面操作以外で画面が閉じられる場合の処理。
     * ホームキー、戻るキー、電源ボタンを想定。
     * スヌーズが設定されていればスヌーズするし、設定されていなければ次回アラーム設定。
     */
    private void leaveByHardkeyEvent() {
        String snoozePref = PreferenceUtils.getString(this, "snooze");
        if (snoozePref != null && !snoozePref.equals(""))
            snooze();
        else
            nextAlarm();
    }

    private void nextAlarm() {
        // 次回アラーム計算は重いのでアラームを止めてからアラームを計算する
        finish();
        // finish呼んだ後でも何故か続きのコードは実行される…
        // スヌーズを止めて次のアラームを設定
        AppAlarmManager.getInstance(DoAlarmActivity.this).cancelSnooze();
        AppAlarmManager.getInstance(DoAlarmActivity.this).refreshAlarm();
        SimpleWidgetProvider.validateView(this.getApplicationContext());
    }

    private void snooze() {
        finish();
        AppAlarmManager.getInstance(this).setSnooze();
        SimpleWidgetProvider.validateView(this.getApplicationContext());
    }

}
