package jp.sourceforge.tamanegisoul.sa.util;

import android.content.Context;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;

public class DBHelper extends SQLiteOpenHelper {

    /** ローカルのカレンダーのURI */
    public static final Uri URI_CALENDAR = Uri.parse("content://com.android.calendar/events");

    public static final String T_HOLIDAY = "holiday"; // 休日テーブル
    public static final String C_HOLIDAY_ID = "_id"; // ID
    public static final String C_HOLIDAY_DATE = "date"; // 日付
    public static final String C_HOLIDAY_NAME = "name"; // 名称

    public DBHelper(Context context) {
        super(context, "ScheduleAlarm.db", null, 1);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL("create table holiday (_id integer primary key autoincrement, date text not null, name text not null);");
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public static final void dump(Cursor c) {
        StringBuilder str = new StringBuilder();
        String value;
        if (c.moveToFirst()) {
            do {
                int count = c.getColumnCount();
                str.delete(0, str.length());
                for (int i = 0; i < count; i++) {
                    try {
                        value = c.getString(i);
                    } catch (CursorIndexOutOfBoundsException e) {
                        value = "null";
                    }
                    str.append(c.getColumnName(i)).append("->").append(value).append(", ");
                }
                LogUtil.d(str.toString());
            } while (c.moveToNext());
        }
    }

}
