package jp.sourceforge.tamanegisoul.er;

import java.util.Date;

import javax.jdo.annotations.IdGeneratorStrategy;
import javax.jdo.annotations.IdentityType;
import javax.jdo.annotations.PersistenceCapable;
import javax.jdo.annotations.Persistent;
import javax.jdo.annotations.PrimaryKey;

import com.google.appengine.api.datastore.Text;

@PersistenceCapable(identityType = IdentityType.APPLICATION)
public class ErrorReport {

    @PrimaryKey
    @Persistent(valueStrategy = IdGeneratorStrategy.IDENTITY)
    private Long id;

    @Persistent
    private String device;

    @Persistent
    private String model;

    @Persistent
    private String sdkVersion;

    @Persistent
    private String appName;

    @Persistent
    private String appVersion;
    
    @Persistent
    private Text message;
    
    @Persistent
    private Date date;

    @Persistent
    private Boolean fixed;

    public ErrorReport(String device, String model, String sdkVersion, String appName, String appVersion, Text message, Date date, Boolean fixed) {
        super();
        this.device = device;
        this.model = model;
        this.sdkVersion = sdkVersion;
        this.appName = appName;
        this.appVersion = appVersion;
        this.message = message;
        this.date = date;
        this.fixed = fixed;
    }

    public Boolean getFixed() {
        return fixed;
    }

    public void setFixed(Boolean fixed) {
        this.fixed = fixed;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getAppName() {
        return appName;
    }

    public String getAppVersion() {
        return appVersion;
    }

    public String getDevice() {
        return device;
    }

    public Long getId() {
        return id;
    }

    public Text getMessage() {
        return message;
    }

    public String getModel() {
        return model;
    }

    public String getSdkVersion() {
        return sdkVersion;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMessage(Text message) {
        this.message = message;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }
}
