package jp.sourceforge.tamanegisoul.sa;

import java.util.Arrays;

import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Vibrator;
import android.preference.ListPreference;
import android.preference.PreferenceActivity;
import android.preference.RingtonePreference;

/**
 * 設定画面
 */
public class AppPreferenceActivity extends PreferenceActivity implements OnSharedPreferenceChangeListener {

    private static final String KEY_VIBRATOR = "vibrator";
    private static final String KEY_RINGTONE = "ringtone";
    private static final String KEY_SNOOZE = "snooze";

    private Vibrator mVibrator;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mVibrator = (Vibrator) getSystemService("vibrator");
        addPreferencesFromResource(R.layout.preference);
        setTitle(getResources().getString(R.string.preference));
    }

    @Override
    public void onResume() {
        super.onResume();
        setPreferenceSummary();
        getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
    }

    @Override
    public void onPause() {
        super.onPause();
        getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
    }

    @Override
    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        setPreferenceSummary();
        // 設定したバイブレーターを一度鳴らす
        if (key.equals(KEY_VIBRATOR)) {
            long[] pattern = PreferenceUtils.getVibratorPattern(this);
            if (pattern != null)
                mVibrator.vibrate(pattern[1]);
        }

    }

    /**
     * ビューに設定値を表示する。
     */
    private void setPreferenceSummary() {
        SharedPreferences sharedPreferences = getPreferenceScreen().getSharedPreferences();
        // 着信音
        String ringtoneValue = sharedPreferences.getString(KEY_RINGTONE, "");
        RingtonePreference ringtonePreference = (RingtonePreference) findPreference(KEY_RINGTONE);
        if (ringtoneValue.equals("")) {
            ringtonePreference.setSummary(getResources().getString(R.string.silent));
        } else {
            Uri uri = Uri.parse(ringtoneValue);
            Ringtone ringtone = RingtoneManager.getRingtone(this, uri);
            ringtonePreference.setSummary(ringtone.getTitle(this));
        }
        // バイブレーター
        String vibratorValue = sharedPreferences.getString(KEY_VIBRATOR, "");
        ListPreference vibratorListPreference = (ListPreference) findPreference(KEY_VIBRATOR);
        if (vibratorValue.equals("")) {
            vibratorListPreference.setSummary(getResources().getString(R.string.not_set));
        } else {
            String[] values = getResources().getStringArray(R.array.array_vibrator_value);
            int index = Arrays.binarySearch(values, vibratorValue);
            vibratorListPreference.setSummary(getResources().getStringArray(R.array.array_vibrator)[index]);
        }
        // スヌーズ
        String snoozeValue = sharedPreferences.getString(KEY_SNOOZE, "");
        ListPreference snoozeListPreference = (ListPreference) findPreference(KEY_SNOOZE);
        if (snoozeValue.equals("")) {
            snoozeListPreference.setSummary(getResources().getString(R.string.not_set));
        } else {
            String[] values = getResources().getStringArray(R.array.array_snooze_value);
            int index = Arrays.binarySearch(values, snoozeValue);
            snoozeListPreference.setSummary(getResources().getStringArray(R.array.array_snooze)[index]);
        }
    }
}