package jp.sourceforge.tamanegisoul.sa.action;

import java.util.Calendar;

import jp.sourceforge.tamanegisoul.sa.R;
import jp.sourceforge.tamanegisoul.sa.util.AppAlarmManager;
import jp.sourceforge.tamanegisoul.sa.util.DBHelper;
import jp.sourceforge.tamanegisoul.sa.util.FormatUtils;
import jp.sourceforge.tamanegisoul.sa.util.PreferenceUtils;
import jp.sourceforge.tamanegisoul.sa.widget.GoogleCalQueryProgressDialog;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class DashboardActivity extends Activity {

    private SQLiteDatabase mDatabase;
    private Cursor mCursor;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.dashboard);

        // スケジュールリスト
        mDatabase = new DBHelper(this).getReadableDatabase();
        mCursor = mDatabase.query(DBHelper.T_CALENDAR, null, null, null, null, null, DBHelper.C_CALENDAR_DATE);
        SimpleCursorAdapter ca = new SimpleCursorAdapter(this, android.R.layout.simple_list_item_2, mCursor, new String[] { DBHelper.C_CALENDAR_NAME, DBHelper.C_CALENDAR_DATE }, new int[] { android.R.id.text1, android.R.id.text2 });
        ca.setViewBinder(new SimpleCursorAdapter.ViewBinder() {
            @Override
            public boolean setViewValue(View view, Cursor cursor, int columnIndex) {
                String text = null;
                if (view.getId() == android.R.id.text1) {
                    // タイトル表示
                    text = cursor.getString(cursor.getColumnIndex(DBHelper.C_CALENDAR_NAME));
                } else if (view.getId() == android.R.id.text2) {
                    // 日時表示
                    StringBuilder str = new StringBuilder();
                    str.append(cursor.getString(cursor.getColumnIndex(DBHelper.C_CALENDAR_DATE)));
                    String time = cursor.getString(cursor.getColumnIndex(DBHelper.C_CALENDAR_TIME));
                    if (time != null)
                        str.append(" ").append(time);
                    text = str.toString();
                }
                ((TextView) view).setText(text);
                return true;
            }
        });
        ((ListView) findViewById(R.id.schedule_list)).setAdapter(ca);

        // 同期ボタン
        ((Button) findViewById(R.id.sync_button)).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                GoogleCalQueryProgressDialog dialog = new GoogleCalQueryProgressDialog(DashboardActivity.this);
                dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        if (!((GoogleCalQueryProgressDialog) dialog).isCanceled()) {
                            AppAlarmManager alarmManager = AppAlarmManager.getInstance(DashboardActivity.this);
                            alarmManager.resetAlarm(true);
                            // 次回アラーム表示を更新
                            ((TextView) DashboardActivity.this.findViewById(R.id.next_alarm_text)).setText(alarmManager.getNextAlarmTimeString());
                            mCursor.requery();
                        }
                    }
                });
                dialog.show();
            }
        });
        ((Button) findViewById(R.id.calendar_button)).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://www.google.com/calendar")));
            }
        });
        ((Button) findViewById(R.id.preference_button)).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(DashboardActivity.this, AppPreferenceActivity.class));
            }
        });
        ((Button) findViewById(R.id.holiday_list_button)).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(DashboardActivity.this, HolidayListActivity.class));
            }
        });
        ((Button) findViewById(R.id.help_button)).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String versionName;
                try {
                    PackageInfo packageInfo = getPackageManager().getPackageInfo(getPackageName(), PackageManager.GET_META_DATA);
                    versionName = packageInfo.versionName;
                } catch (NameNotFoundException e) {
                    e.printStackTrace();
                    versionName = "不明";
                }
                AlertDialog alertDialog = new AlertDialog.Builder(DashboardActivity.this).create();
                alertDialog.setMessage(String.format("現在のバージョン：%s\nサポートページに移動しますか？", versionName));
                alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(android.R.string.ok), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://sourceforge.jp/projects/schedulealarm/wiki/FrontPage")));
                    }
                });
                alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(android.R.string.cancel), new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                alertDialog.show();
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
        // initializing view
        ((Button) findViewById(R.id.sync_button)).setEnabled(PreferenceUtils.getString(this, PreferenceUtils.KEY_ACCOUNT) != null);
        ((TextView) findViewById(R.id.next_alarm_text)).setText(AppAlarmManager.getInstance(this).getNextAlarmTimeString());

        // 未設定なら設定画面強制表示
        if (PreferenceUtils.getString(this, PreferenceUtils.KEY_WEEKDAY_TIME) == null || PreferenceUtils.getString(this, PreferenceUtils.KEY_HOLIDAY_TIME) == null) {
            AlertDialog dialog = new AlertDialog.Builder(this).create();
            dialog.setMessage("アラーム時刻を設定してください");
            dialog.setButton(AlertDialog.BUTTON_POSITIVE, "設定する", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    startActivity(new Intent(DashboardActivity.this, AppPreferenceActivity.class));
                }
            });
            dialog.show();
        }

        mCursor.requery();

        // 今日は何の日表示 
        {
            SQLiteDatabase db = null;
            String dayTitle = "平日";
            Calendar today = Calendar.getInstance();
            if(today.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY){
                dayTitle = "土曜日";
            }
            if(today.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY){
                dayTitle = "日曜日";
            }
            try {
                db = new DBHelper(this).getReadableDatabase();
                Cursor c = db.query(DBHelper.T_HOLIDAY, null, DBHelper.C_HOLIDAY_DATE + "=?", new String[] { FormatUtils.formatDate(today) }, null, null, null);
                if (c.moveToFirst()) {
                    dayTitle = c.getString(c.getColumnIndex(DBHelper.C_HOLIDAY_NAME));
                }
            } finally {
                if (db != null)
                    db.close();
            }
            ((TextView) findViewById(R.id.day_notation)).setText(String.format("今日は%sです", dayTitle));
        }
    }

    @Override
    protected void onPause() {
        // TODO Auto-generated method stub
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        // TODO Auto-generated method stub
        super.onDestroy();
        mDatabase.close();
    }

}
