package jp.sourceforge.tamanegisoul.sa;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DBHelper extends SQLiteOpenHelper {

    public static final String T_ALARM = "alarm"; // アラームテーブル
    public static final String C_ALARM_ID = "_id"; // アラームID
    public static final String C_ALARM_ENEBLED = "enabled"; // 有効？
    public static final String C_ALARM_HOUR = "hour"; // 時
    public static final String C_ALARM_MINUTE = "minute"; // 分
    public static final String C_ALARM_WEEKDAY = "weekday"; // 平日に鳴らす？
    public static final String C_ALARM_WEEKEND = "weekend"; // 土日に鳴らす？
    public static final String C_ALARM_HOLIDAY = "holiday"; // 休日に鳴らす？
    public static final String T_HOLIDAY = "holiday"; // 休日テーブル
    public static final String C_HOLIDAY_ID = "_id"; // 休日ID
    public static final String C_HOLIDAY_DATE = "date"; // 日付
    public static final String C_HOLIDAY_NAME = "name"; // 名称

    public DBHelper(Context context) {
        super(context, "ScheduleAlarm.db", null, 1);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL("create table holiday (_id integer primary key autoincrement, date text not null, name text not null);");
        db.execSQL("create table alarm (_id integer primary key autoincrement, hour integer, minute integer, enabled integer, weekday integer, weekend integer, holiday integer);");
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

    }

}
