package jp.sourceforge.tamanegisoul.sa.util;

import java.util.Date;


import android.content.Context;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.format.DateFormat;

public class DBHelper extends SQLiteOpenHelper {

    public static final String T_HOLIDAY = "holiday"; // 休日テーブル
    public static final String C_HOLIDAY_ID = "_id"; // ID
    public static final String C_HOLIDAY_DATE = "date"; // 日付
    public static final String C_HOLIDAY_NAME = "name"; // 名称
    public static final String T_CALENDAR = "calendar"; // Googleカレンダーテーブル
    public static final String C_CALENDAR_ID="_id"; // ID
    public static final String C_CALENDAR_NAME = "name"; // スケジュール名
    public static final String C_CALENDAR_DATE="date"; // 日付
    public static final String C_CALENDAR_TIME="time"; // 時刻
    public static final String C_CALENDAR_IS_CANCEL="is_cancel"; // -alarm設定なら1、+alarm設定なら0
    

    public DBHelper(Context context) {
        super(context, "ScheduleAlarm.db", null, 1);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL("create table holiday (_id integer primary key autoincrement, date text not null, name text not null);");
        db.execSQL("create table alarm (_id integer primary key autoincrement, hour integer, minute integer, enabled integer, weekday integer, weekend integer, holiday integer);");
        db.execSQL("create table calendar (_id integer primary key autoincrement, date text not null, time text, is_cancel text not null, name text not null);");
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 106 && newVersion >= 106) {
            db.execSQL("create table calendar (_id integer primary key autoincrement, datetime text not null, name text not null);");
        }
    }

    public static String toDateString(Date date) {
        return DateFormat.format("yyyy-MM-dd", date).toString();
    }

    public static String toDateTimeString(Date date) {
        return DateFormat.format("hh:mmaa", date).toString();
    }
    
    public static final void dump(Cursor c) {
        StringBuilder str = new StringBuilder();
        String value;
        if(c.moveToFirst()){
            do{
                int count = c.getColumnCount();
                for(int i = 0; i < count; i++){
                    try{
                        // TODO ？
                        value = c.getString(i);
                    }catch(CursorIndexOutOfBoundsException e){
                        value = "null";
                    }
                    str.append(c.getColumnName(i)).append("->").append(value).append(", ");
                }
                str.append("\n");
            }while(c.moveToNext());
        }
        LogUtil.d(str.toString());
    }

}
