package jp.sourceforge.tamanegisoul.sa.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import jp.sourceforge.tamanegisoul.sa.util.AppAlarmManager;
import jp.sourceforge.tamanegisoul.sa.util.DBHelper;
import jp.sourceforge.tamanegisoul.sa.util.LogUtil;
import jp.sourceforge.tamanegisoul.sa.util.PreferenceUtils;
import android.app.Service;
import android.content.Intent;
import android.database.ContentObserver;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;

public class CalendarObserverService extends Service {

    private LocalBinder mBinder;
    private CalendarObserver mCalendarObserver;
    private List<OnCalendarChangeListener> mListeners;

    public static interface OnCalendarChangeListener {
        public void onChange();
    }

    public class LocalBinder extends Binder {
        public CalendarObserverService getService() {
            return CalendarObserverService.this;
        }
    }
    
    private class CalendarObserver extends ContentObserver {
        private Date mLatestUpdate;
        public CalendarObserver() {
            super(new Handler());
        }
        @Override
        public void onChange(boolean selfChange) {
            LogUtil.d("CalendarObserver.onChange(%s)", selfChange);
            // 何度も呼ばれるので、1秒以内のイベントは無視
            Date now = new Date();
            if (mLatestUpdate == null || now.getTime() - mLatestUpdate.getTime() > 1000 * 1) {
                mLatestUpdate = now;
                // アラーム更新
                AppAlarmManager alarmManager = AppAlarmManager.getInstance(CalendarObserverService.this);
                alarmManager.refreshAlarm();
                // 最新同期時刻を記憶
                PreferenceUtils.setDateTime(getApplicationContext(), PreferenceUtils.KEY_LATEST_SYNC_TIME, mLatestUpdate);
                // リスナー通知
                for(OnCalendarChangeListener listener : mListeners){
                    listener.onChange();
                }
            }
        }
    }

    @Override
    public void onCreate() {
        LogUtil.d("CalendarObserverService.onCreate()");
        super.onCreate();
        mBinder = new LocalBinder();
        mCalendarObserver = new CalendarObserver();
        mListeners = new ArrayList<OnCalendarChangeListener>();
    }

    @Override
    public void onStart(Intent intent, int startId) {
        LogUtil.d("CalendarObserverService.onStart()");
        super.onStart(intent, startId);
        getContentResolver().registerContentObserver(DBHelper.URI_CALENDAR_EVENTS, false, mCalendarObserver);
    }

    @Override
    public IBinder onBind(Intent arg0) {
        return mBinder;
    }

    @Override
    public void onDestroy() {
        LogUtil.d("CalendarObserverService.onDestroy()");
        super.onDestroy();
        getContentResolver().unregisterContentObserver(mCalendarObserver);
    }

    public boolean addOnCalendarChangeListener(OnCalendarChangeListener listener) {
        return mListeners.add(listener);
    }

    public boolean removeOnCalendarChangeListener(OnCalendarChangeListener listener) {
        return mListeners.remove(listener);
    }
}
