package jp.sourceforge.tamanegisoul.sa;

import android.app.ListActivity;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

/**
 * アラーム一覧画面
 */
public class AlarmListActivity extends ListActivity {

    private static final int MENU_ADD = 1; // アラーム追加メニュー

    private SQLiteDatabase mDataBase;
    private Cursor mCursor;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        // 初期化
        super.onCreate(savedInstanceState);
        setContentView(R.layout.alarm_list);
        mDataBase = new DBHelper(this).getReadableDatabase();
        mCursor = mDataBase.query(DBHelper.T_ALARM, null, null, null, null, null, null);

        // リストビューを設定
        SimpleCursorAdapter ca = new SimpleCursorAdapter(this, android.R.layout.simple_list_item_2, mCursor, new String[] { DBHelper.C_ALARM_HOUR,
                DBHelper.C_ALARM_MINUTE }, new int[] { android.R.id.text1, android.R.id.text2 });
        ca.setViewBinder(new SimpleCursorAdapter.ViewBinder() {
            @Override
            public boolean setViewValue(View view, Cursor cursor, int columnIndex) {
                String text = null;
                if (view.getId() == android.R.id.text1) {
                    // 時刻表記
                    text = String.format("%02d:%02d", cursor.getInt(cursor.getColumnIndex(DBHelper.C_ALARM_HOUR)), cursor.getInt(cursor
                            .getColumnIndex(DBHelper.C_ALARM_MINUTE)));
                } else if (view.getId() == android.R.id.text2) {
                    // 設定表記
                    // TODO リテラルを外部化
                    StringBuilder b = new StringBuilder();
                    b.append(cursor.getInt(cursor.getColumnIndex(DBHelper.C_ALARM_ENEBLED)) == 1 ? "有効 " : "無効 ");
                    b.append(cursor.getInt(cursor.getColumnIndex(DBHelper.C_ALARM_WEEKDAY)) == 1 ? "平日 " : "");
                    b.append(cursor.getInt(cursor.getColumnIndex(DBHelper.C_ALARM_WEEKEND)) == 1 ? "土日 " : "");
                    b.append(cursor.getInt(cursor.getColumnIndex(DBHelper.C_ALARM_HOLIDAY)) == 1 ? "祝日 " : "");
                    text = b.toString();
                }
                ((TextView) view).setText(text);
                return true;
            }
        });
        setListAdapter(ca);

        // リスト項目の選択リスナー
        getListView().setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                // アラームIDを渡してアラーム画面を表示
                Intent i = new Intent(parent.getContext(), AlarmActivity.class);
                i.putExtra(DBHelper.C_ALARM_ID, mCursor.getInt(mCursor.getColumnIndex(DBHelper.C_ALARM_ID)));
                startActivity(i);
            }
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
        // リストの表示を更新
        mCursor.requery();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mDataBase.close();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuItem menuItem = menu.add(Menu.NONE, MENU_ADD, Menu.NONE, R.string.add_alarm);
        menuItem.setIcon(android.R.drawable.ic_menu_add);
        return super.onCreateOptionsMenu(menu);
    }

    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        switch (item.getItemId()) {
        case MENU_ADD:
            // アラームIDを渡さずにアラーム画面を追加
            startActivity(new Intent(this, AlarmActivity.class));
            break;
        }
        return super.onMenuItemSelected(featureId, item);
    }

}
