/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.subr;

import net.morilib.lisp.LispString;

public class StringCILessThanEq extends StringCompare {

	@Override
	protected boolean compare(LispString c1a, LispString c2a) {
		String s1 = c1a.getString().toUpperCase().toLowerCase();
		String s2 = c2a.getString().toUpperCase().toLowerCase();
		
		return s1.compareTo(s2) <= 0;
	}
	
	
	public String toString() {
		return "Subr:string-ci<=?";
	}
	
}
