/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.swing.tree;

import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/07/14
 */
public class JtreeNodeInsertS extends QuaternaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.BinaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a,
			Environment env, LispMessage mesg) {
		int i = SubrUtils.getSmallInt(c4a, mesg);

		if(!(c1a instanceof LispJTree)) {
			throw mesg.getError("err.swing.require.jtree", c1a);
		} else if(!(c2a instanceof LispJTreeNode)) {
			throw mesg.getError("err.swing.require.jtree.node", c2a);
		} else if(c3a instanceof Cons) {
			LispJTreeUtils.insertNode(
					c1a, c2a, i, LispJTreeUtils.sToNode(c3a), mesg);
			return Undef.UNDEF;
		} else {
			LispJTreeUtils.insertNode(
					c1a, c2a, i, new MyMutableTreeNode(c3a), mesg);
			return Undef.UNDEF;
		}
	}

}
