
#ifndef __RING_H__

#define __RING_H__

#define RING_NUM    6

extern unsigned char	r_write;
extern unsigned char    r_read1;
extern unsigned char    r_read2;
extern unsigned char	r_num;

#define ring_clear()    ring_read_set(ring_write_get(t))

void ring_init(void);

//読み出し位置1
#define ring_read1_get() r_read1
void ring_read1_set(unsigned char i);
void ring_read1_plus(void);

//読み出し位置2
#define ring_read2_get() r_read2
void ring_read2_set(unsigned char i);
void ring_read2_plus(void);

// 書き込み位置
#define ring_write_get()    r_write
inline extern void ring_write_plus(void)
{
    r_write++;
    if (r_write >= r_num) r_write = 0;
}

unsigned char ring_num1_get();
unsigned char ring_is_full1(void);

unsigned char ring_num2_get();
unsigned char ring_is_full2(void);

#endif

