#if	!defined(__AVG_RING_H__)
#define	__AVG_RING_H__

#include <time.h>
#include "spi.h"

// リングバッファサイズ　個数
#define	AD_RING_NUM	(60 * 5)

#define AD_CHNUM	6	// AD CH数
#define AD_SAMPLE	50	// AD ICの出力レート　[Hz]
#define	AD_BYTES	3	// AD 1sample dataのバイト数

// NAV-TIMEUTCパケットのデータ格納
typedef struct {
    unsigned long   tow;    // ms GPS Millisecond Time of Week
    unsigned long   tacc;   // ns Time Accuracy Estimate
    long   nano;            // ns Nanoseconds of second, range -1e9 .. 1e9 (UTC)
    unsigned int    year;   //  UTC
    unsigned char   month;	// 
    unsigned char   day;
    unsigned char   hour;
    unsigned char   min;
    unsigned char   sec;
    unsigned char   valid;  // Validity Flags
                            //  bit0 validTOW 1 = Valid Time of Week
                            //  bit1 validWKN 1 = Valid Week Number
                            //  bit2 validUTC 1 = Valid UTC (Leap Seconds already known)
} UbloxNavTimeUtc;

// リングバッファのデータタイプ
typedef struct {
	char	rescode;					// コマンドに対する返答 ACK/NAK/NUL
	char	resdata[SPI_RESDATA_LEN];	// コマンドに対する返答データ
	UbloxNavTimeUtc gps;			// GPSタイムスタンプ　SPIで受信
	struct tm t;					// タイムスタンプ　struct tmの月は(0〜11)なので注意 年は1900からのオフセット
	int	freq;						// 平均周波数 Hz
	long data1sec[AD_CHNUM];		// 1sec平均値　SPIで受信
	long data[AD_CHNUM][AD_SAMPLE];	// AD_SAMPLE[Hz]の生データ　SPIで受信
	long avg[AD_CHNUM][AD_SAMPLE];	// 平均後データ
	unsigned int	checksum;	// SPI受信データのchecksumフィールド
} AdData;



int ad_ring_init(void);

void ad_ring_clear_sec(void);
void ad_ring_clear_high(void);
void ad_ring_clear_latest(void);

int ad_ring_read_get_sec(void);
void ad_ring_read_set_sec(int i);
void ad_ring_read_plus_sec(void);
int ad_ring_num_get_sec(void);

int ad_ring_read_get_high(void);
void ad_ring_read_set_high(int i);
void ad_ring_read_plus_high(void);
int ad_ring_num_get_high(void);

int ad_ring_write_get(void);
void ad_ring_write_plus(void);
int ad_ring_latest_get(void);
void ad_ring_latest_set(int i);
AdData* ad_ring_get(int ptr);
void ad_ring_set(AdData *data);
int ad_ring_full(void);

#ifdef	CUNIT
	#include <CUnit/CUnit.h>
	void ad_ring_test(CU_pSuite test_suite);
#endif

#endif
