#include <stdio.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <stdarg.h>
//#include <getopt.h>
#include <stdlib.h>
#include <assert.h>
#include <signal.h>
#include <pthread.h>
#include <syslog.h>

#include <stdint.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/i2c-dev.h> /* for I2C_SLAVE */

#include <sys/stat.h>

#include "my_thread.h"
#include "spi.h"
#include "ad_ring.h"
#include "sts.h"
#include "thread_rec.h"
#include "conf.h"
#include "ad_file.h"
#include "lcd.h"

// debug_print.h内で#define	DEBUG_PRINTしているので
// リリース時は、debug_print.hでコメントする
#include "debug_print.h"

#define	MES_PRINT
#include	"mes_print.h"

// ダミーデータを自分で発生するときに定義
//#define	DUMMY

#define	VERSION	"1.0.1"

#define	DEV_SPI	"/dev/spike-ad"

/**** 設定デフォルト値
*/
#define	CONF_FREQ_DEF	50
#define	CONF_GAIN_DEF	SPI_CMD_GAIN_1P4
#define	CONF_LINUX_TIME_SET_DEF	1	// OFF

//
/**** signal ***********************************************************
*/
void cleanup(void)
{
	spi_close();
}
void sig_handler(int sig)
{
	char	szBuf[128];
	static int	busy = 0;

	if (busy) return;
	busy = 1;

	sprintf(szBuf, "signal trap. signal=%d\n", sig);
	PDEBUG("%s", szBuf);
	fflush(stdout);
	fflush(stderr);

	cleanup();
	exit(0);
}
//
/**** main
*/
int main (int argc, char *argv[])
{
	pthread_t	tid_rcv, tid_disp;
//	char	buf[512];
	
	signal(SIGINT, sig_handler);
	signal(SIGQUIT, sig_handler);
	signal(SIGKILL, sig_handler);
	signal(SIGTERM, sig_handler);

	lcd_init();
	lcd_pos(6, 1);
	lcd_print("sciLogger");
	lcd_pos(0, 3);

	ad_ring_init();
	sts_init();

//printf("%d\n", sizeof(UbloxNavTimeUtcRecType));
//printf("%d\n", sizeof(HighSampleRecType));
//goto END;

	// デフォルト設定
	conf_freq_set(CONF_FREQ_DEF);
	conf_gain_set(CONF_GAIN_DEF);
	conf_linux_time_set_set(CONF_LINUX_TIME_SET_DEF);
	// 設定ファイル読み込み
	conf_read();
	PDEBUG("freq=%d\n", conf_freq_get());
	PDEBUG("gain=%d\n", conf_gain_get());
	lcd_print("*");

	PDEBUG("sciLogger %s START\n", VERSION);
	sleep(1);
//
/**** デバイスOPEN
*/
	if (spi_open(DEV_SPI) < 0) {
		perror("spi_open() ERROR!");
		goto END;
	}
	lcd_print("*");

//
/**** PGA設定
*/
	spi_cmd_send_gain(conf_gain_get());
	lcd_print("*");
//
/**** スレッド生成
*/
	// SPI RCVと平均
	if (pthread_create(&tid_rcv, NULL, thread_rcv, NULL) != 0) {
		perror("pthread_create(SPI RCV)");
		goto END;
	} else {
		PDEBUG("SPI RCV thread create\n");
	}
	lcd_print("*");
	// 表示
	if (pthread_create(&tid_disp, NULL, thread_disp, NULL) != 0) {
		perror("pthread_create(DISP)");
		goto END;
	} else {
		PDEBUG("DISP thread create\n");
	}
	lcd_print("*");

//
/**** メインループ 記録 ************************
*/
	// 記録スレッド
	thread_rec(NULL);
END:
	sig_handler(0);

	return 0;
}
