#include <stdio.h>
#include <unistd.h>
#include <syslog.h>

#include "ad_ring.h"
#include "lcd.h"
#include "debug_print.h"
#include "conf.h"

/*

*/
static void scr_disp_time(AdData *d)
{
	int	iLeft, iY;
	char	buf[128];
	struct tm *t;
	
	t = &(d->t);
	iLeft = 0;
	iY = 0;
	/*	Time */
	lcd_pos(iLeft, iY++);
	sprintf(buf, "%02d/%02d/%02d %02d:%02d:%02d %02X",
		t->tm_year % 100, t->tm_mon+1, t->tm_mday, t->tm_hour, t->tm_min, t->tm_sec,
		d->gps.valid);
	lcd_print(buf);
}
/*

*/
static void scr_disp_ad(AdData *d)
{
	int	iLeft, iY;
	char	buf[128];
	int	ch = 0;
	
	iLeft = 0;
	iY = 1;
	for(ch = 0; ch < 3; ch++) {
		sprintf(buf, "%d% 8ld", ch+1, d->data1sec[ch]);
		lcd_pos(iLeft, iY++);
		lcd_print(buf);
	}
	iLeft = 10;
	iY = 1;
	for(ch = 3; ch < 6; ch++) {
		sprintf(buf, "%d% 8ld", ch+1, d->data1sec[ch]);
		lcd_pos(iLeft, iY++);
		lcd_print(buf);
	}
}
//
/**** システム時刻設定 ***************************************
*/
/*
	システムにGPS時刻設定する
	* UTのみ対応

	tm_mon 
	1月からの通算月数、0 から 11 までの値。 
	tm_year 
	1900 年からの通算年数。 

struct tm *gps
	GPSの時刻(UT or JST)
	tm_gmtoff(UTに対するローカルタイムオフセット 秒)を設定しておくこと

*/
static void systime_set(struct tm *gps)
{
	struct tm	time_tm;
	time_t	t;
//	long	ofs;

	time_tm = *gps;
	time_tm.tm_year = (gps->tm_year % 100) + 100;
//	time_tm.tm_mon = gps->tm_mon - 1;
//syslog(LOG_INFO, "a tm_gmtoff=%d timezone=%d\n", time_tm.tm_gmtoff, timezone);
	// timegm()実行後にtm_gmtoffが変化してしまうので保存する
//	ofs = time_tm.tm_gmtoff;
	t = timegm(&time_tm);
//	t += ofs;

	// tm_gmtoff(UTに対するローカルタイムオフセット 秒)を元にして計算する
//	t = timelocal(&time_tm);
//syslog(LOG_INFO, "b tm_gmtoff=%d timezone=%d\n", time_tm.tm_gmtoff, timezone);

	if (t == -1) {
		syslog(LOG_ERR, "systime_set(): mktime err\n");
		PDEBUGF("mktime err\n");
		return;
	}

	if (stime(&t) != 0) {
		syslog(LOG_ERR, "systime_set(): stime err\n");
		PDEBUGF("stime err\n");
	}
}

void* thread_disp(void* pParam)
{
	int	i;
	AdData *d;

	i = ad_ring_latest_get();
//	scr_init();
	lcd_clear();
	while(1) {
		// FG表示
		if (i != ad_ring_latest_get()) {
			i = ad_ring_latest_get();
			// データ取得
			d = ad_ring_get(i);
			// 時刻表示
			scr_disp_time(d);
			// AD表示
			scr_disp_ad(d);
			// 1分に1回
			if (d->t.tm_sec == 10) {
				// システム時刻設定する
				if (conf_linux_time_set_get()) {
					// GPS Validチェック, tacc < 1000nsec
					if (((d->gps.valid & 0x07) == 0x07) && (d->gps.tacc < 1000)) {
						systime_set(&(d->t));
						PDEBUGF("SET linux system time\n");
					}
				}
			}
		}
		usleep(100*1000);
	}
}
