/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime;

import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.util.FinalArrayList;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ContentHandlerAdaptor
extends DefaultHandler {
    private final FinalArrayList prefixMap = new FinalArrayList();
    private final XMLSerializer serializer;
    private final StringBuffer text = new StringBuffer();

    ContentHandlerAdaptor(XMLSerializer _serializer) {
        this.serializer = _serializer;
    }

    public void startDocument() {
        this.prefixMap.clear();
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMap.add(prefix);
        this.prefixMap.add(uri);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            int i;
            this.flushText();
            int len = atts.getLength();
            this.serializer.startElement(namespaceURI, localName, this.getPrefix(qName), null);
            for (i = 0; i < len; ++i) {
                String qname = atts.getQName(i);
                if (qname.startsWith("xmlns")) continue;
                String prefix = this.getPrefix(qname);
                this.serializer.getNamespaceContext().declareNamespace(atts.getURI(i), prefix, true);
            }
            for (i = 0; i < this.prefixMap.size(); i += 2) {
                String prefix = (String)this.prefixMap.get(i);
                this.serializer.getNamespaceContext().declareNamespace((String)this.prefixMap.get(i + 1), prefix, prefix.length() != 0);
            }
            this.serializer.endNamespaceDecls(null);
            for (i = 0; i < len; ++i) {
                if (atts.getQName(i).startsWith("xmlns")) continue;
                this.serializer.attribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
            }
            this.prefixMap.clear();
            this.serializer.endAttributes();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    private String getPrefix(String qname) {
        int idx = qname.indexOf(58);
        String prefix = idx == -1 ? qname : qname.substring(0, idx);
        return prefix;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.flushText();
            this.serializer.endElement();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    private void flushText() throws SAXException, IOException, XMLStreamException {
        if (this.text.length() != 0) {
            this.serializer.text(this.text.toString(), null);
            this.text.setLength(0);
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.text.append(ch, start, length);
    }
}

