package jp.co.secioss.SeciossOTP;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ListActivity;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.widget.Button;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;

public class SeciossOTPSecret extends ListActivity {

	private static final int DIALOG_RESET = 0;
	private static final int DIALOG_DELETE = 1;

	protected static final int ACTIVITY_CREATE = 5;
    private static final int ACTIVITY_EDIT = 6;

    private static final int RESET_ID = Menu.FIRST;
    private static final int DELETE_ID = Menu.FIRST + 1;

    private SeciossOTPDbAdapter mDbHelper;
    private TextView tvTitle;
    private Long mRowId;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.seciossotp_secret);
        setTitle(R.string.seciossotp_secret_title);

        tvTitle = (TextView) findViewById(R.id.seciossotp_secret_title2);

        mDbHelper = new SeciossOTPDbAdapter(this);
        mDbHelper.open();
        fillData();
        registerForContextMenu(getListView());

        Button button_create = (Button) findViewById(R.id.button_create);
        button_create.setOnClickListener(new View.OnClickListener() {
        	public void onClick(View view) {
        		createSecret();
                setResult(RESULT_OK);
            }
        });

    }

    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        menu.add(0, RESET_ID, 0, R.string.menu_reset);
        menu.add(0, DELETE_ID, 0, R.string.menu_delete);
    }

    @Override
    public boolean onContextItemSelected(MenuItem item) {
    	AdapterContextMenuInfo info = (AdapterContextMenuInfo) item.getMenuInfo();
    	mRowId = info.id;

    	switch(item.getItemId()) {
            case RESET_ID:
            	showDialog(DIALOG_RESET);
                return true;

            case DELETE_ID:
            	showDialog(DIALOG_DELETE);
                return true;
        }
        return super.onContextItemSelected(item);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        super.onActivityResult(requestCode, resultCode, intent);
        fillData();
    }

    @Override
    public Dialog onCreateDialog(int id) {
    	AlertDialog dialog = null;
    	AlertDialog.Builder builder = new AlertDialog.Builder(this);
    	switch(id) {
	    	case DIALOG_RESET:
	        	builder.setMessage("リセットしますか？")
	        	.setCancelable(true)
	        	.setPositiveButton("はい", new DialogInterface.OnClickListener() {
	        		public void onClick(DialogInterface dialog, int id) {
	        			resetSecret();
	        		}
	        	})
	        	.setNegativeButton("いいえ", new DialogInterface.OnClickListener() {
	        		public void onClick(DialogInterface dialog, int id) {
	        			dialog.cancel();
	        		}
	        	});
	        	dialog = builder.create();
	        break;

	    	case DIALOG_DELETE:
	        	builder.setMessage("削除しますか？")
	        	.setCancelable(true)
	        	.setPositiveButton("はい", new DialogInterface.OnClickListener() {
	        		public void onClick(DialogInterface dialog, int id) {
	        			deleteSecret();
	        		}
	        	})
	        	.setNegativeButton("いいえ", new DialogInterface.OnClickListener() {
	        		public void onClick(DialogInterface dialog, int id) {
	        			dialog.cancel();
	        		}
	        	});
	        	dialog = builder.create();
	        break;
    	}
    	return dialog;
    }

    /**
     * シークレットを新規する
     */
    protected void createSecret() {
        Intent i = new Intent(this, SeciossOTPSecretEdit.class);
        startActivityForResult(i, ACTIVITY_CREATE);
    }

    /**
     * シークレットをリセットする
     */
    private void resetSecret() {
      Intent i = new Intent(this, SeciossOTPSecretEdit.class);
      i.putExtra(SeciossOTPDbAdapter.KEY_ROWID, mRowId);
      startActivityForResult(i, ACTIVITY_EDIT);
    }

    /**
     * シークレットを削除する
     */
    private void deleteSecret() {
        mDbHelper.deleteSecret(mRowId);
        fillData();
    }

    /**
     * シークレットを取得する
     */
    private void fillData() {
    	Cursor c = mDbHelper.fetchAllSecrets();
    	if (null != c) {
	    	if (c.getCount() == 0) {
	            tvTitle.setText(R.string.no_secrets);
	    	}
	    	else {
	    		tvTitle.setText(R.string.select_secrets);
	    	}

	    	startManagingCursor(c);
	        String[] from = new String[]{SeciossOTPDbAdapter.KEY_ALIAS};
	        int[] to = new int[]{R.id.secret_row_title};
	        SimpleCursorAdapter sca = new SimpleCursorAdapter(
	        		this, R.layout.seciossotp_secret_row, c, from, to);
	        setListAdapter(sca);
    	}
    }

}
